/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Set;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.zookeeper.Watcher;

public class SessionFailRetryLoop
implements Closeable {
    private final CuratorZookeeperClient client;
    private final Thread ourThread;
    private final Watcher watcher;
    private static final Set<Thread> failedSessionThreads = Sets.newSetFromMap(Maps.newConcurrentMap());

    static boolean sessionForThreadHasFailed() {
        return failedSessionThreads.size() > 0 && failedSessionThreads.contains(Thread.currentThread());
    }

    @Override
    public void close() {
        Preconditions.checkState(Thread.currentThread().equals(this.ourThread), "Not in the correct thread");
        failedSessionThreads.remove(this.ourThread);
        this.client.removeParentWatcher(this.watcher);
    }

    public static enum Mode {
        RETRY,
        FAIL;

    }

    public static class SessionFailedException
    extends Exception {
    }
}

