/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.io.Serializable;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;

public class CommonToken
implements Serializable,
Token {
    protected int type;
    protected int line;
    protected int charPositionInLine = -1;
    protected int channel = 0;
    protected transient CharStream input;
    protected String text;
    protected int index = -1;
    protected int start;
    protected int stop;

    public CommonToken(int type) {
        this.type = type;
    }

    public CommonToken(CharStream input, int type, int channel, int start, int stop) {
        this.input = input;
        this.type = type;
        this.channel = channel;
        this.start = start;
        this.stop = stop;
    }

    public CommonToken(int type, String text) {
        this.type = type;
        this.channel = 0;
        this.text = text;
    }

    public int getType() {
        return this.type;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.input == null) {
            return null;
        }
        int n = this.input.size();
        if (this.start < n && this.stop < n) {
            return this.input.substring(this.start, this.stop);
        }
        return "<EOF>";
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public void setCharPositionInLine(int charPositionInLine) {
        this.charPositionInLine = charPositionInLine;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getTokenIndex() {
        return this.index;
    }

    public void setTokenIndex(int index) {
        this.index = index;
    }

    public CharStream getInputStream() {
        return this.input;
    }

    public String toString() {
        String txt;
        String channelStr = "";
        if (this.channel > 0) {
            channelStr = ",channel=" + this.channel;
        }
        if ((txt = this.getText()) != null) {
            txt = txt.replaceAll("\n", "\\\\n");
            txt = txt.replaceAll("\r", "\\\\r");
            txt = txt.replaceAll("\t", "\\\\t");
        } else {
            txt = "<no text>";
        }
        return "[@" + this.getTokenIndex() + "," + this.start + ":" + this.stop + "='" + txt + "',<" + this.type + ">" + channelStr + "," + this.line + ":" + this.getCharPositionInLine() + "]";
    }
}

