/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int lastMarker;
    protected int p = -1;
    protected int range = -1;

    public BufferedTokenStream() {
    }

    public BufferedTokenStream(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    public int index() {
        return this.p;
    }

    public int mark() {
        if (this.p == -1) {
            this.setup();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void seek(int index) {
        this.p = index;
    }

    public int size() {
        return this.tokens.size();
    }

    public void consume() {
        if (this.p == -1) {
            this.setup();
        }
        ++this.p;
        this.sync(this.p);
    }

    protected void sync(int i) {
        int n = i - this.tokens.size() + 1;
        if (n > 0) {
            this.fetch(n);
        }
    }

    protected void fetch(int n) {
        for (int i = 1; i <= n; ++i) {
            Token t = this.tokenSource.nextToken();
            t.setTokenIndex(this.tokens.size());
            this.tokens.add(t);
            if (t.getType() == -1) break;
        }
    }

    public int LA(int i) {
        return this.LT(i).getType();
    }

    protected Token LB(int k) {
        if (this.p - k < 0) {
            return null;
        }
        return this.tokens.get(this.p - k);
    }

    public Token LT(int k) {
        if (this.p == -1) {
            this.setup();
        }
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        int i = this.p + k - 1;
        this.sync(i);
        if (i >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        if (i > this.range) {
            this.range = i;
        }
        return this.tokens.get(i);
    }

    protected void setup() {
        this.sync(0);
        this.p = 0;
    }

    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    public String toString() {
        if (this.p == -1) {
            this.setup();
        }
        this.fill();
        return this.toString(0, this.tokens.size() - 1);
    }

    public String toString(int start, int stop) {
        Token t;
        if (start < 0 || stop < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = start; i <= stop && (t = this.tokens.get(i)).getType() != -1; ++i) {
            buf.append(t.getText());
        }
        return buf.toString();
    }

    public String toString(Token start, Token stop) {
        if (start != null && stop != null) {
            return this.toString(start.getTokenIndex(), stop.getTokenIndex());
        }
        return null;
    }

    public void fill() {
        if (this.p == -1) {
            this.setup();
        }
        if (this.tokens.get(this.p).getType() == -1) {
            return;
        }
        int i = this.p + 1;
        this.sync(i);
        while (this.tokens.get(i).getType() != -1) {
            this.sync(++i);
        }
    }
}

