/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.util.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    private final Iterator<V> iterator;

    public DepthFirstIterator(DirectedGraph<V, E> graph, V start) {
        List<V> list = this.buildList(graph, start);
        this.iterator = list.iterator();
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(final DirectedGraph<V, E> graph, final V start) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new DepthFirstIterator(graph, start);
            }
        };
    }

    private List<V> buildList(DirectedGraph<V, E> graph, V start) {
        ArrayList list = new ArrayList();
        this.buildListRecurse(list, new HashSet(), graph, start);
        return list;
    }

    private void buildListRecurse(List<V> list, Set<V> activeVertices, DirectedGraph<V, E> graph, V start) {
        if (!activeVertices.add(start)) {
            return;
        }
        list.add(start);
        List<E> edges = graph.getOutwardEdges(start);
        for (DefaultEdge edge : edges) {
            this.buildListRecurse(list, activeVertices, graph, edge.target);
        }
        activeVertices.remove(start);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Object next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

