/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectedGraph<V, E extends DefaultEdge>
implements DirectedGraph<V, E> {
    final Set<E> edges = new LinkedHashSet();
    final Map<V, VertexInfo<V, E>> vertexMap = new LinkedHashMap<V, VertexInfo<V, E>>();
    final DirectedGraph.EdgeFactory<V, E> edgeFactory;

    public DefaultDirectedGraph(DirectedGraph.EdgeFactory<V, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public static <V> DefaultDirectedGraph<V, DefaultEdge> create() {
        return new DefaultDirectedGraph(DefaultEdge.factory());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("graph(").append("vertices: ").append(this.vertexMap.keySet()).append(", edges: ").append(this.edges).append(")");
        return buf.toString();
    }

    @Override
    public boolean addVertex(Object vertex) {
        if (this.vertexMap.containsKey(vertex)) {
            return false;
        }
        this.vertexMap.put(vertex, new VertexInfo());
        return true;
    }

    @Override
    public Set<E> edgeSet() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public DefaultEdge addEdge(Object vertex, Object targetVertex) {
        VertexInfo<V, E> info = this.vertexMap.get(vertex);
        if (info == null) {
            throw new IllegalArgumentException("no vertex " + vertex);
        }
        VertexInfo<V, E> info2 = this.vertexMap.get(targetVertex);
        if (info2 == null) {
            throw new IllegalArgumentException("no vertex " + targetVertex);
        }
        DefaultEdge edge = (DefaultEdge)this.edgeFactory.createEdge(vertex, targetVertex);
        if (this.edges.add(edge)) {
            info.outEdges.add(edge);
            return edge;
        }
        return null;
    }

    @Override
    public boolean removeEdge(Object source, Object target) {
        VertexInfo<V, E> info = this.vertexMap.get(source);
        List outEdges = info.outEdges;
        int size = outEdges.size();
        for (int i = 0; i < size; ++i) {
            DefaultEdge edge = (DefaultEdge)outEdges.get(i);
            if (!edge.target.equals(target)) continue;
            outEdges.remove(i);
            this.edges.remove(edge);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        return this.vertexMap.keySet();
    }

    @Override
    public void removeAllVertices(Collection<V> collection) {
        this.vertexMap.keySet().removeAll(collection);
        for (VertexInfo<V, E> info : this.vertexMap.values()) {
            Iterator iterator = info.outEdges.iterator();
            while (iterator.hasNext()) {
                DefaultEdge next = (DefaultEdge)iterator.next();
                if (!collection.contains(next.target)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public List<E> getOutwardEdges(V source) {
        return this.vertexMap.get(source).outEdges;
    }

    @Override
    public List<E> getInwardEdges(V target) {
        ArrayList<DefaultEdge> list = new ArrayList<DefaultEdge>();
        for (VertexInfo<V, E> info : this.vertexMap.values()) {
            for (DefaultEdge edge : info.outEdges) {
                if (!edge.target.equals(target)) continue;
                list.add(edge);
            }
        }
        return list;
    }

    final Object source(DefaultEdge edge) {
        return edge.source;
    }

    final Object target(DefaultEdge edge) {
        return edge.target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VertexInfo<V, E> {
        public List<E> outEdges = new ArrayList();

        VertexInfo() {
        }
    }
}

