/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.eigenbase.util.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSets {
    public static boolean contains(BitSet set0, BitSet set1) {
        int i = set1.nextSetBit(0);
        while (i >= 0) {
            if (!set0.get(i)) {
                return false;
            }
            i = set1.nextSetBit(i + 1);
        }
        return true;
    }

    public static Iterable<Integer> toIter(final BitSet bitSet) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    int i;
                    {
                        this.i = bitSet.nextSetBit(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i >= 0;
                    }

                    @Override
                    public Integer next() {
                        int prev = this.i;
                        this.i = bitSet.nextSetBit(this.i + 1);
                        return prev;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static IntList toList(BitSet bitSet) {
        IntList list = new IntList();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            list.add(i);
            i = bitSet.nextSetBit(i + 1);
        }
        return list;
    }

    public static BitSet of(int ... bits) {
        BitSet bitSet = new BitSet();
        for (int bit : bits) {
            bitSet.set(bit);
        }
        return bitSet;
    }

    public static BitSet of(Collection<? extends Number> bits) {
        BitSet bitSet = new BitSet();
        for (Number number : bits) {
            bitSet.set(number.intValue());
        }
        return bitSet;
    }

    public static BitSet range(int fromIndex, int toIndex) {
        BitSet bitSet = new BitSet();
        if (toIndex > fromIndex) {
            bitSet.set(fromIndex, toIndex);
        }
        return bitSet;
    }

    public static BitSet range(int toIndex) {
        return BitSets.range(0, toIndex);
    }
}

