/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRun {
    private static final Ordering<String[]> ORDERING = Ordering.natural().nullsLast().lexicographical().onResultOf(new Function<String[], Iterable<Comparable>>(){

        public Iterable<Comparable> apply(String[] input) {
            return Arrays.asList(input);
        }
    });
    private PrintWriter printWriter;
    private boolean sort;

    private static String pad(String s, int width, boolean right) {
        int x;
        if (s == null) {
            s = "";
        }
        if ((x = width - s.length()) <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        if (right) {
            buf.append(SqlRun.chars(' ', x)).append(s);
        } else {
            buf.append(s).append(SqlRun.chars(' ', x));
        }
        return buf.toString();
    }

    private static CharSequence chars(final char c, final int length) {
        return new CharSequence(){

            public String toString() {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    buf.append(c);
                }
                return buf.toString();
            }

            public int length() {
                return length;
            }

            public char charAt(int index) {
                return c;
            }

            public CharSequence subSequence(int start, int end) {
                return SqlRun.chars(c, end - start);
            }
        };
    }

    private static void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort, boolean mysql) throws SQLException {
        int i;
        int i2;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int n = metaData.getColumnCount();
        int[] widths = new int[n];
        ArrayList<String[]> rows = new ArrayList<String[]>();
        boolean[] rights = new boolean[n];
        for (i2 = 0; i2 < n; ++i2) {
            widths[i2] = metaData.getColumnLabel(i2 + 1).length();
        }
        while (resultSet.next()) {
            String[] row = new String[n];
            for (i = 0; i < n; ++i) {
                String value = resultSet.getString(i + 1);
                widths[i] = Math.max(widths[i], value == null ? 0 : value.length());
                row[i] = value;
            }
            rows.add(row);
        }
        for (i2 = 0; i2 < widths.length; ++i2) {
            switch (metaData.getColumnType(i2 + 1)) {
                case 4: {
                    rights[i2] = true;
                }
            }
        }
        if (sort) {
            Collections.sort(rows, ORDERING);
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < n; ++i) {
            buf.append(mysql || i > 0 ? "+" : "");
            buf.append(SqlRun.chars('-', widths[i] + 2));
        }
        buf.append(mysql ? "+" : "");
        String hyphens = SqlRun.flush(buf);
        if (mysql) {
            headerLines.add(hyphens);
        }
        for (int i3 = 0; i3 < n; ++i3) {
            buf.append(i3 > 0 ? " | " : (mysql ? "| " : " "));
            buf.append(SqlRun.pad(metaData.getColumnLabel(i3 + 1), widths[i3], false));
        }
        buf.append(mysql ? " |" : "");
        headerLines.add(SqlRun.flush(buf));
        headerLines.add(hyphens);
        for (String[] row : rows) {
            for (int i4 = 0; i4 < n; ++i4) {
                buf.append(i4 > 0 ? " | " : (mysql ? "| " : " "));
                String s = !mysql && i4 == n - 1 && !rights[i4] ? row[i4] : SqlRun.pad(row[i4], widths[i4], rights[i4]);
                buf.append(s);
            }
            buf.append(mysql ? " |" : "");
            bodyLines.add(SqlRun.flush(buf));
        }
        if (mysql) {
            footerLines.add(hyphens);
        }
        footerLines.add(rows.size() == 1 ? "(1 row)" : "(" + rows.size() + " rows)");
        footerLines.add("");
    }

    private static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property {
        OUTPUTFORMAT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OutputFormat {
        CSV{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                int i;
                ResultSetMetaData metaData = resultSet.getMetaData();
                PrintWriter pw = run.printWriter;
                int n = metaData.getColumnCount();
                for (i = 0; i < n; ++i) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    pw.print(metaData.getColumnLabel(i + 1));
                }
                pw.println();
                while (resultSet.next()) {
                    for (i = 0; i < n; ++i) {
                        if (i > 0) {
                            pw.print(", ");
                        }
                        pw.print(resultSet.getString(i + 1));
                    }
                    pw.println();
                }
            }
        }
        ,
        PSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                SqlRun.format(resultSet, headerLines, bodyLines, footerLines, run.sort, false);
            }
        }
        ,
        MYSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                SqlRun.format(resultSet, headerLines, bodyLines, footerLines, run.sort, true);
            }
        };


        public abstract void format(ResultSet var1, List<String> var2, List<String> var3, List<String> var4, SqlRun var5) throws Exception;
    }
}

