/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.PlannerImpl;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.Programs;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.StdFrameworkConfig;
import org.eigenbase.relopt.Context;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.sql2rel.StandardConvertletTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frameworks {
    public static Planner getPlanner(FrameworkConfig config) {
        return new PlannerImpl(config);
    }

    public static <R> R withPlanner(final PlannerAction<R> action, FrameworkConfig config) {
        return Frameworks.withPrepare(new PrepareAction<R>(config){

            @Override
            public R apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                return action.apply(cluster, relOptSchema, rootSchema);
            }
        });
    }

    public static <R> R withPrepare(PrepareAction<R> action) {
        try {
            Class.forName("net.hydromatic.optiq.jdbc.Driver");
            Connection connection = DriverManager.getConnection("jdbc:optiq:");
            OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
            OptiqServerStatement statement = optiqConnection.createStatement().unwrap(OptiqServerStatement.class);
            return new OptiqPrepareImpl().perform(statement, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigBuilder newConfigBuilder() {
        return new ConfigBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigBuilder {
        private SqlRexConvertletTable convertletTable = StandardConvertletTable.INSTANCE;
        private SqlOperatorTable operatorTable = SqlStdOperatorTable.instance();
        private ImmutableList<Program> programs = ImmutableList.of();
        private Context context;
        private ImmutableList<RelTraitDef> traitDefs;
        private SqlParser.ParserConfig parserConfig = new SqlParser.ParserConfigImpl(Lex.ORACLE, 128);
        private SchemaPlus defaultSchema;
        private RelOptCostFactory costFactory;
        private SqlParserImplFactory parserFactory = SqlParserImpl.FACTORY;

        private ConfigBuilder() {
        }

        public FrameworkConfig build() {
            return new StdFrameworkConfig(this.context, this.convertletTable, this.operatorTable, this.programs, this.traitDefs, this.parserConfig, this.defaultSchema, this.costFactory, this.parserFactory);
        }

        public ConfigBuilder context(Context c) {
            Preconditions.checkNotNull(c);
            this.context = c;
            return this;
        }

        public ConfigBuilder convertletTable(SqlRexConvertletTable table) {
            Preconditions.checkNotNull(table);
            this.convertletTable = table;
            return this;
        }

        public ConfigBuilder operatorTable(SqlOperatorTable table) {
            Preconditions.checkNotNull(table);
            this.operatorTable = table;
            return this;
        }

        public ConfigBuilder traitDefs(List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs == null ? null : ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder parserConfig(SqlParser.ParserConfig parserConfig) {
            Preconditions.checkNotNull(parserConfig);
            this.parserConfig = parserConfig;
            return this;
        }

        public ConfigBuilder defaultSchema(SchemaPlus defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public ConfigBuilder costFactory(RelOptCostFactory costFactory) {
            this.costFactory = costFactory;
            return this;
        }

        public ConfigBuilder ruleSets(RuleSet ... ruleSets) {
            this.programs = ImmutableList.copyOf(Programs.listOf(ruleSets));
            return this;
        }

        public ConfigBuilder parserFactory(SqlParserImplFactory parserFactory) {
            Preconditions.checkNotNull(parserFactory);
            this.parserFactory = parserFactory;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PrepareAction<R> {
        private final FrameworkConfig config;

        public PrepareAction(FrameworkConfig config) {
            this.config = config;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }

        public abstract R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, OptiqServerStatement var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

