/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.text.DecimalFormat;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.function.Deterministic;
import net.hydromatic.linq4j.function.Function1;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = new Function1<List<Object>, Enumerable<Object>>(){

        public Enumerable<Object> apply(List<Object> list) {
            return Linq4j.asEnumerable(list);
        }
    };

    private SqlFunctions() {
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim_(s, false, true, ' ');
    }

    private static String trim_(String s, boolean left, boolean right, char c) {
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (s.charAt(j - 1) != c) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (s.charAt(i) != c) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static long powerX(long a, long b) {
        long x = 1L;
        while (b > 0L) {
            x *= a;
            --b;
        }
        return x;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static String unixTimestampToString(long timestamp) {
        StringBuilder buf = new StringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        SqlFunctions.unixDateToString(buf, date);
        buf.append(' ');
        SqlFunctions.unixTimeToString(buf, time);
        return buf.toString();
    }

    public static String unixTimeToString(int time) {
        StringBuilder buf = new StringBuilder(8);
        SqlFunctions.unixTimeToString(buf, time);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time) {
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        SqlFunctions.int2(buf, h);
        buf.append(':');
        SqlFunctions.int2(buf, m);
        buf.append(':');
        SqlFunctions.int2(buf, s);
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static String unixDateToString(int date) {
        StringBuilder buf = new StringBuilder(10);
        SqlFunctions.unixDateToString(buf, date);
        return buf.toString();
    }

    private static void unixDateToString(StringBuilder buf, int date) {
        SqlFunctions.julianToString(buf, date + 2440588);
    }

    private static void julianToString(StringBuilder buf, int julian) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        SqlFunctions.int4(buf, year);
        buf.append('-');
        SqlFunctions.int2(buf, month);
        buf.append('-');
        SqlFunctions.int2(buf, day);
    }

    public static String intervalYearMonthToString(int v, TimeUnitRange range) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case YEAR: {
                v = SqlFunctions.roundUp(v, 12);
                int y = v / 12;
                buf.append(y);
                break;
            }
            case YEAR_TO_MONTH: {
                int y = v / 12;
                buf.append(y);
                buf.append('-');
                int m = v % 12;
                SqlFunctions.number(buf, m, 2);
                break;
            }
            case MONTH: {
                int m = v;
                buf.append(m);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    private static StringBuilder number(StringBuilder buf, int v, int n) {
        for (int k = SqlFunctions.digitCount(v); k < n; ++k) {
            buf.append('0');
        }
        return buf.append(v);
    }

    public static int digitCount(int v) {
        int n = 1;
        while ((v /= 10) != 0) {
            ++n;
        }
        return n;
    }

    public static String intervalDayTimeToString(long v, TimeUnitRange range, int scale) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0L) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case DAY_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = (v /= 60L) % 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case DAY_TO_MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = (v /= 60L) % 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                break;
            }
            case DAY_TO_HOUR: {
                v = SqlFunctions.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                break;
            }
            case DAY: {
                v = SqlFunctions.roundUp(v, 86400000L);
                long d = v / 86400000L;
                buf.append((int)d);
                break;
            }
            case HOUR: {
                v = SqlFunctions.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h = v /= 60L;
                buf.append((int)h);
                break;
            }
            case HOUR_TO_MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = (v /= 60L) % 60L;
                long h = v /= 60L;
                buf.append((int)h);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                break;
            }
            case HOUR_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = (v /= 60L) % 60L;
                long h = v /= 60L;
                buf.append((int)h);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case MINUTE_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = v /= 60L;
                buf.append((int)m);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = v /= 60L;
                buf.append((int)m);
                break;
            }
            case SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = v /= 1000L;
                buf.append((int)s);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    private static long roundUp(long dividend, long divisor) {
        long remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2L > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    private static int roundUp(int dividend, int divisor) {
        int remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2 > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    private static void fraction(StringBuilder buf, int scale, long ms) {
        if (scale > 0) {
            buf.append('.');
            long v1 = scale == 3 ? ms : (scale == 2 ? ms / 10L : (scale == 1 ? ms / 100L : 0L));
            SqlFunctions.number(buf, (int)v1, scale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnitRange {
        YEAR,
        YEAR_TO_MONTH,
        MONTH,
        DAY,
        DAY_TO_HOUR,
        DAY_TO_MINUTE,
        DAY_TO_SECOND,
        HOUR,
        HOUR_TO_MINUTE,
        HOUR_TO_SECOND,
        MINUTE,
        MINUTE_TO_SECOND,
        SECOND;


        public boolean monthly() {
            return this.ordinal() <= MONTH.ordinal();
        }
    }
}

