/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ByteString;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.rules.java.CallImplementor;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexToLixTranslator {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = Util.mapOf(RexToLixTranslator.findMethod(String.class, "toUpperCase", new Class[0]), SqlStdOperatorTable.UPPER, RexToLixTranslator.findMethod(SqlFunctions.class, "substring", String.class, Integer.TYPE, Integer.TYPE), SqlStdOperatorTable.SUBSTRING, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHARACTER_LENGTH, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHAR_LENGTH);
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final RexProgram program;
    private final InputGetter inputGetter;
    private final BlockBuilder list;
    private final Map<? extends RexNode, Boolean> exprNullableMap;
    private final RexToLixTranslator parent;

    private static Method findMethod(Class<?> clazz, String name, Class ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, InputGetter inputGetter, BlockBuilder list) {
        this(program, typeFactory, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory));
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, InputGetter inputGetter, BlockBuilder list, Map<RexNode, Boolean> exprNullableMap, RexBuilder builder) {
        this(program, typeFactory, inputGetter, list, exprNullableMap, builder, null);
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, InputGetter inputGetter, BlockBuilder list, Map<? extends RexNode, Boolean> exprNullableMap, RexBuilder builder, RexToLixTranslator parent) {
        this.program = program;
        this.typeFactory = typeFactory;
        this.inputGetter = inputGetter;
        this.list = list;
        this.exprNullableMap = exprNullableMap;
        this.builder = builder;
        this.parent = parent;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, PhysType outputPhysType, InputGetter inputGetter) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, inputGetter, list).translateList(program.getProjectList(), storageTypes);
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter) {
        return new RexToLixTranslator(null, typeFactory, inputGetter, list);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        Expression expression = this.translate0(expr, nullAs, storageType);
        assert (expression != null);
        return this.list.append("v", expression);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert = null;
        block0 : switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert = operand;
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltinMethod.STRING_TO_BOOLEAN.method, operand);
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.UNIX_DATE_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIME: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.UNIX_TIME_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.UNIX_TIMESTAMP_TO_STRING.method, operand));
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, operand, Expressions.constant((Object)interval.foo())));
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.INTERVAL_DAY_TIME_TO_STRING.method, operand, Expressions.constant((Object)interval.foo()), Expressions.constant(interval.getFractionalSecondPrecision())));
                        break block0;
                    }
                    case BOOLEAN: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltinMethod.BOOLEAN_TO_STRING.method, operand));
                    }
                }
            }
        }
        if (convert == null) {
            convert = RexToLixTranslator.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        switch (sourceType.getSqlTypeName()) {
            case CHAR: {
                switch (targetType.getSqlTypeName()) {
                    case VARCHAR: {
                        convert = Expressions.call(BuiltinMethod.RTRIM.method, convert);
                    }
                }
                break;
            }
            case BINARY: {
                switch (targetType.getSqlTypeName()) {
                    case VARBINARY: {
                        convert = Expressions.call(BuiltinMethod.RTRIM.method, convert);
                    }
                }
            }
        }
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: 
            case BINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARBINARY: 
                    case BINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (sourcePrecision < 0 || sourcePrecision >= 0 && sourcePrecision <= targetPrecision) break;
                    }
                    default: {
                        convert = Expressions.call(BuiltinMethod.TRUNCATE.method, convert, Expressions.constant(targetPrecision));
                        break;
                    }
                }
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert = Expressions.call(BuiltinMethod.ROUND_LONG.method, convert, Expressions.constant((long)Math.pow(10.0, 3 - targetScale)));
            }
        }
        return convert;
    }

    private Expression translate0(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (nullAs == RexImpTable.NullAs.NULL && !expr.getType().isNullable()) {
            nullAs = RexImpTable.NullAs.NOT_POSSIBLE;
        }
        switch (expr.getKind()) {
            case INPUT_REF: {
                int index = ((RexInputRef)expr).getIndex();
                Expression x = this.inputGetter.field(this.list, index, storageType);
                Expression input = this.list.append("inp" + index + "_", x);
                if (nullAs == RexImpTable.NullAs.NOT_POSSIBLE && input.type.equals(storageType)) {
                    return input;
                }
                Expression nullHandled = nullAs.handle(input);
                if (nullHandled instanceof ConstantExpression) {
                    return nullHandled;
                }
                if (nullHandled == input) {
                    return input;
                }
                String unboxVarName = "v_unboxed";
                if (input instanceof ParameterExpression) {
                    unboxVarName = ((ParameterExpression)input).name + "_unboxed";
                }
                ParameterExpression unboxed = Expressions.parameter(nullHandled.getType(), this.list.newName(unboxVarName));
                this.list.add(Expressions.declare(16, unboxed, nullHandled));
                return unboxed;
            }
            case LOCAL_REF: {
                return this.translate(this.program.getExprList().get(((RexLocalRef)expr).getIndex()), nullAs, storageType);
            }
            case LITERAL: {
                return RexToLixTranslator.translateLiteral(expr, this.nullifyType(expr.getType(), this.isNullable(expr) && nullAs != RexImpTable.NullAs.NOT_POSSIBLE), this.typeFactory, nullAs);
            }
            case DYNAMIC_PARAM: {
                return this.translateParameter((RexDynamicParam)expr, nullAs, storageType);
            }
        }
        if (expr instanceof RexCall) {
            return this.translateCall((RexCall)expr, nullAs);
        }
        throw new RuntimeException("cannot translate expression " + expr);
    }

    private Expression translateCall(RexCall call, RexImpTable.NullAs nullAs) {
        SqlOperator operator = call.getOperator();
        CallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        return implementor.implement(this, call, nullAs);
    }

    private Expression translateParameter(RexDynamicParam expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (storageType == null) {
            storageType = this.typeFactory.getJavaClass(expr.getType());
        }
        return nullAs.handle(RexToLixTranslator.convert(Expressions.call((Expression)DataContext.ROOT, BuiltinMethod.DATA_CONTEXT_GET.method, Expressions.constant("?" + expr.getIndex())), storageType));
    }

    public static Expression translateLiteral(RexNode expr, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        RexLiteral literal = (RexLiteral)expr;
        Comparable value = literal.getValue();
        if (value == null) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw AlwaysNull.INSTANCE;
                }
                case NULL: {
                    return RexImpTable.NULL_EXPR;
                }
            }
        } else {
            switch (nullAs) {
                case IS_NOT_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case IS_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
            }
        }
        Class<Object> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                assert (javaClass == BigDecimal.class);
                return value == null ? Expressions.constant(null) : Expressions.new_(BigDecimal.class, new Expression[]{Expressions.constant(value.toString())});
            }
            case DATE: {
                value2 = value == null ? null : Integer.valueOf((int)(((Calendar)value).getTimeInMillis() / 86400000L));
                break;
            }
            case TIME: {
                value2 = value == null ? null : Integer.valueOf((int)(((Calendar)value).getTimeInMillis() % 86400000L));
                break;
            }
            case TIMESTAMP: {
                value2 = value == null ? null : Long.valueOf(((Calendar)value).getTimeInMillis());
                break;
            }
            case INTERVAL_DAY_TIME: {
                if (value == null) {
                    value2 = null;
                    javaClass = Long.class;
                    break;
                }
                value2 = ((BigDecimal)value).longValue();
                javaClass = Long.TYPE;
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                if (value == null) {
                    value2 = null;
                    javaClass = Integer.class;
                    break;
                }
                value2 = ((BigDecimal)value).intValue();
                javaClass = Integer.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = value == null ? null : ((NlsString)value).getValue();
                break;
            }
            case VARBINARY: 
            case BINARY: {
                return Expressions.new_(ByteString.class, new Expression[]{Expressions.constant(((ByteString)value).getBytes(), byte[].class)});
            }
            case SYMBOL: {
                value2 = value;
                javaClass = value.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr(javaClass);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant(value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (RexNode rex : operandList) {
            list.add(this.translate(rex, nullAs));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, (List<? extends Type>)null);
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox(translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter) {
        if (program.getCondition() == null) {
            return RexImpTable.TRUE_EXPR;
        }
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, inputGetter, list);
        return translator.translate((RexNode)program.getCondition(), RexImpTable.NullAs.FALSE);
    }

    public static Expression convert(Expression operand, Type toType) {
        boolean fromNumber;
        Type fromType = operand.getType();
        if (fromType.equals(toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of(toType);
        Primitive toBox = Primitive.ofBox(toType);
        Primitive fromBox = Primitive.ofBox(fromType);
        Primitive fromPrimitive = Primitive.of(fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, "parse" + SqlFunctions.initcap(toPrimitive.primitiveName), operand);
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, "valueOf", operand);
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_(operand, toPrimitive.primitiveClass);
            }
            if (fromNumber) {
                return Expressions.unbox(operand, toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.box(Expressions.unbox(operand, toBox), toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert || Primitive.of(una.getType()) == toBox) {
                    return Expressions.box(una.expression, toBox);
                }
            }
            return Expressions.box(operand, toBox);
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.new_(BigDecimal.class, new Expression[]{Expressions.unbox(operand, fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, new Expression[]{operand});
            }
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toBigDecimal", new Expression[]{operand}));
        }
        if (toType == String.class) {
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, "toString", operand);
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand}));
            }
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(operand, "toString", new Expression[0]));
        }
        return Expressions.convert_(operand, toType);
    }

    public Expression translateConstructor(List<RexNode> operandList, SqlKind kind) {
        switch (kind) {
            case MAP_VALUE_CONSTRUCTOR: {
                Expression map = this.list.append("map", Expressions.new_(LinkedHashMap.class), false);
                for (int i = 0; i < operandList.size(); ++i) {
                    RexNode key = operandList.get(i++);
                    RexNode value = operandList.get(i);
                    this.list.add(Expressions.statement(Expressions.call(map, BuiltinMethod.MAP_PUT.method, Expressions.box(this.translate(key)), Expressions.box(this.translate(value)))));
                }
                return map;
            }
            case ARRAY_VALUE_CONSTRUCTOR: {
                Expression lyst = this.list.append("list", Expressions.new_(ArrayList.class), false);
                for (RexNode value : operandList) {
                    this.list.add(Expressions.statement(Expressions.call(lyst, BuiltinMethod.COLLECTION_ADD.method, Expressions.box(this.translate(value)))));
                }
                return lyst;
            }
        }
        throw new AssertionError((Object)("unexpected: " + (Object)((Object)kind)));
    }

    public boolean isNullable(RexNode e) {
        if (!e.getType().isNullable()) {
            return false;
        }
        Boolean b = this.isKnownNullable(e);
        return b == null || b != false;
    }

    protected Boolean isKnownNullable(RexNode node) {
        Boolean nullable;
        if (!this.exprNullableMap.isEmpty() && (nullable = this.exprNullableMap.get(node)) != null) {
            return nullable;
        }
        return this.parent == null ? null : this.parent.isKnownNullable(node);
    }

    public RexToLixTranslator setNullable(RexNode e, boolean nullable) {
        return this.setNullable(Collections.singletonMap(e, nullable));
    }

    public RexToLixTranslator setNullable(Map<? extends RexNode, Boolean> nullable) {
        if (nullable == null || nullable.isEmpty()) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.inputGetter, this.list, nullable, this.builder, this);
    }

    public RelDataType nullifyType(RelDataType type, boolean nullable) {
        Primitive primitive;
        if (!nullable && (primitive = this.javaPrimitive(type)) != null) {
            return this.typeFactory.createJavaType(primitive.primitiveClass);
        }
        return this.typeFactory.createTypeWithNullability(type, nullable);
    }

    private Primitive javaPrimitive(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return Primitive.ofBox(((RelDataTypeFactoryImpl.JavaType)type).getJavaClass());
        }
        return null;
    }

    static class AlwaysNull
    extends ControlFlowException {
        public static final AlwaysNull INSTANCE = new AlwaysNull();

        private AlwaysNull() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputGetterImpl
    implements InputGetter {
        private List<Pair<Expression, PhysType>> inputs;

        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            int offset = 0;
            for (Pair<Expression, PhysType> input : this.inputs) {
                PhysType physType = (PhysType)input.right;
                int fieldCount = physType.getRowType().getFieldCount();
                if (index >= offset + fieldCount) {
                    offset += fieldCount;
                    continue;
                }
                Expression left = list.append("current", (Expression)input.left);
                return physType.fieldReference(left, index - offset, storageType);
            }
            throw new IllegalArgumentException("Unable to find field #" + index);
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, Type var3);
    }
}

