/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.runtime.FlatLists;
import net.hydromatic.optiq.runtime.Unit;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaRowFormat {
    CUSTOM{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return typeFactory.getJavaClass(type);
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return typeFactory.getJavaClass(type.getFieldList().get(index).getType());
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    assert (javaRowClass == Unit.class);
                    return Expressions.field(null, javaRowClass, "INSTANCE");
                }
            }
            return Expressions.new_(javaRowClass, expressions);
        }

        @Override
        public MemberExpression field(Expression expression, int field, Type fieldType) {
            Type type = expression.getType();
            if (type instanceof Types.RecordType) {
                Types.RecordType recordType = (Types.RecordType)type;
                Types.RecordField recordField = recordType.getRecordFields().get(field);
                return Expressions.field(expression, recordField.getDeclaringClass(), recordField.getName());
            }
            return Expressions.field(expression, Types.nthField(field, type));
        }
    }
    ,
    SCALAR{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() == 1);
            return typeFactory.getJavaClass(type.getFieldList().get(0).getType());
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return this.javaRowClass(typeFactory, type);
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            assert (expressions.size() == 1);
            return expressions.get(0);
        }

        @Override
        public Expression field(Expression expression, int field, Type fieldType) {
            assert (field == 0);
            return expression;
        }
    }
    ,
    LIST{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return FlatLists.ComparableList.class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    return Expressions.field(null, FlatLists.class, "COMPARABLE_EMPTY_LIST");
                }
                case 2: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltinMethod.LIST2.method, expressions), List.class);
                }
                case 3: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltinMethod.LIST3.method, expressions), List.class);
                }
            }
            return Expressions.convert_(Expressions.call(List.class, null, BuiltinMethod.ARRAYS_AS_LIST.method, new Expression[]{Expressions.newArrayInit(Object.class, expressions)}), List.class);
        }

        @Override
        public Expression field(Expression expression, int field, Type fieldType) {
            return RexToLixTranslator.convert(Expressions.call(expression, BuiltinMethod.LIST_GET.method, Expressions.constant(field)), fieldType);
        }
    }
    ,
    ARRAY{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return Object[].class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.newArrayInit(Object.class, JavaRowFormat.stripCasts(expressions));
        }

        @Override
        public Expression comparer() {
            return Expressions.call(null, BuiltinMethod.ARRAY_COMPARER.method, new Expression[0]);
        }

        @Override
        public Expression field(Expression expression, int field, Type fieldType) {
            return RexToLixTranslator.convert(Expressions.arrayIndex(expression, Expressions.constant(field)), fieldType);
        }
    };


    public JavaRowFormat optimize(RelDataType rowType) {
        switch (rowType.getFieldCount()) {
            case 0: {
                return LIST;
            }
            case 1: {
                return SCALAR;
            }
        }
        if (this == SCALAR) {
            return LIST;
        }
        return this;
    }

    abstract Type javaRowClass(JavaTypeFactory var1, RelDataType var2);

    abstract Type javaFieldClass(JavaTypeFactory var1, RelDataType var2, int var3);

    public abstract Expression record(Type var1, List<Expression> var2);

    private static List<Expression> stripCasts(final List<Expression> expressions) {
        return new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                Expression expression = (Expression)expressions.get(index);
                while (expression.getNodeType() == ExpressionType.Convert) {
                    expression = ((UnaryExpression)expression).expression;
                }
                return expression;
            }

            @Override
            public int size() {
                return expressions.size();
            }
        };
    }

    public Expression comparer() {
        return null;
    }

    public abstract Expression field(Expression var1, int var2, Type var3);
}

