/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlAccessType;
import org.eigenbase.sql.validate.SqlMonotonicity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelOptTableImpl
implements Prepare.PreparingTable {
    private final RelOptSchema schema;
    private final RelDataType rowType;
    private final Table table;
    private final Function<Class, Expression> expressionFunction;
    private final ImmutableList<String> names;

    private RelOptTableImpl(RelOptSchema schema, RelDataType rowType, List<String> names, Table table, Function<Class, Expression> expressionFunction) {
        this.schema = schema;
        this.rowType = rowType;
        this.names = ImmutableList.copyOf(names);
        this.table = table;
        this.expressionFunction = expressionFunction;
        assert (expressionFunction != null);
        assert (rowType != null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, List<String> names, Expression expression) {
        Function<Object, Expression> expressionFunction = Functions.constant(expression);
        return new RelOptTableImpl(schema, rowType, names, null, expressionFunction);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, final OptiqSchema.TableEntry tableEntry) {
        Function<Class, Expression> expressionFunction;
        if (tableEntry.getTable() instanceof QueryableTable) {
            final QueryableTable table = (QueryableTable)tableEntry.getTable();
            expressionFunction = new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return table.getExpression(tableEntry.schema.plus(), tableEntry.name, clazz);
                }
            };
        } else {
            expressionFunction = new Function<Class, Expression>(){

                public Expression apply(Class input) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new RelOptTableImpl(schema, rowType, tableEntry.path(), tableEntry.getTable(), expressionFunction);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, TranslatableTable table) {
        Function<Class, Expression> expressionFunction = new Function<Class, Expression>(){

            public Expression apply(Class input) {
                throw new UnsupportedOperationException();
            }
        };
        return new RelOptTableImpl(schema, rowType, ImmutableList.<String>of(), table, expressionFunction);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isInstance(this.table)) {
            return clazz.cast(this.table);
        }
        return null;
    }

    @Override
    public Expression getExpression(Class clazz) {
        return (Expression)this.expressionFunction.apply(clazz);
    }

    @Override
    public double getRowCount() {
        Double rowCount;
        if (this.table != null && (rowCount = this.table.getStatistic().getRowCount()) != null) {
            return rowCount;
        }
        return 100.0;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        if (this.table instanceof TranslatableTable) {
            return ((TranslatableTable)this.table).toRel(context, this);
        }
        RelOptCluster cluster = context.getCluster();
        Class elementType = this.deduceElementType();
        return new JavaRules.EnumerableTableAccessRel(cluster, cluster.traitSetOf(EnumerableConvention.INSTANCE), this, elementType);
    }

    private Class deduceElementType() {
        if (this.table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)this.table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        return Object.class;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public boolean isKey(BitSet columns) {
        return this.table.getStatistic().isKey(columns);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }
}

