/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.QueryableDefaults;
import net.hydromatic.linq4j.QueryableFactory;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.LixToRelTranslator;
import net.hydromatic.optiq.prepare.RelOptTableImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryableRelBuilder<T>
implements QueryableFactory<T> {
    private final LixToRelTranslator translator;
    private RelNode rel;

    public QueryableRelBuilder(LixToRelTranslator translator) {
        this.translator = translator;
    }

    RelNode toRel(Queryable<T> queryable) {
        if (queryable instanceof QueryableDefaults.Replayable) {
            ((QueryableDefaults.Replayable)queryable).replay(this);
            return this.rel;
        }
        if (queryable instanceof AbstractTableQueryable) {
            AbstractTableQueryable tableQueryable = (AbstractTableQueryable)queryable;
            QueryableTable table = tableQueryable.table;
            OptiqSchema.TableEntry tableEntry = OptiqSchema.from(tableQueryable.schema).add(tableQueryable.tableName, tableQueryable.table);
            RelOptTableImpl relOptTable = RelOptTableImpl.create(null, table.getRowType(this.translator.typeFactory), tableEntry);
            if (table instanceof TranslatableTable) {
                return ((TranslatableTable)((Object)table)).toRel(this.translator, relOptTable);
            }
            return new TableAccessRel(this.translator.cluster, relOptTable);
        }
        return this.translator.translate(queryable.getExpression());
    }

    @Override
    public Queryable<T> concat(Queryable<T> source, Enumerable<T> source2) {
        throw new UnsupportedOperationException();
    }
}

