/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqCatalogReader;
import net.hydromatic.optiq.prepare.OptiqSqlValidator;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.sql2rel.SqlToRelConverter;
import org.eigenbase.util.Util;

public class PlannerImpl
implements Planner {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig config;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.ParserConfig parserConfig;
    private final SqlParserImplFactory parserFactory;
    private boolean caseSensitive = true;
    private State state;
    private boolean open;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private OptiqSqlValidator validator;
    private SqlNode validatedSqlNode;
    private SqlToRelConverter sqlToRelConverter;
    private SqlRexConvertletTable convertletTable;
    private RelNode rel;

    public PlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.parserFactory = config.getParserFactory();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.reset();
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
            }
        }
        this.ensure(State.STATE_1_RESET);
        Frameworks.withPlanner(new Frameworks.PlannerAction<Void>(){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                Util.discard(rootSchema);
                PlannerImpl.this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
                PlannerImpl.this.planner = cluster.getPlanner();
                return null;
            }
        }, this.config);
        this.state = State.STATE_2_READY;
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    public SqlNode parse(String sql) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(this.parserFactory, sql, this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        this.validator = this.createSqlValidator(this.createCatalogReader());
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    public RelNode convert(SqlNode sql) throws RelConversionException {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        this.sqlToRelConverter = this.getSqlToRelConverter(this.validator, this.createCatalogReader());
        this.rel = this.sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.rel = this.sqlToRelConverter.flattenTypes(this.rel, true);
        this.rel = this.sqlToRelConverter.decorrelate(this.validatedSqlNode, this.rel);
        this.state = State.STATE_5_CONVERTED;
        return this.rel;
    }

    private OptiqSqlValidator createSqlValidator(OptiqCatalogReader catalogReader) {
        return new OptiqSqlValidator(this.operatorTable, catalogReader, this.typeFactory);
    }

    private SqlToRelConverter getSqlToRelConverter(SqlValidator validator, OptiqCatalogReader catalogReader) {
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(new ViewExpanderImpl(), validator, catalogReader, this.planner, this.createRexBuilder(), this.convertletTable);
        sqlToRelConverter.setTrimUnusedFields(false);
        sqlToRelConverter.enableTableAccessConversion(false);
        return sqlToRelConverter;
    }

    private OptiqCatalogReader createCatalogReader() {
        SchemaPlus rootSchema = PlannerImpl.rootSchema(this.defaultSchema);
        return new OptiqCatalogReader(OptiqSchema.from(rootSchema), this.caseSensitive, OptiqSchema.from(this.defaultSchema).path(null), this.typeFactory);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) throws RelConversionException {
        this.ensure(State.STATE_5_CONVERTED);
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(this.planner, rel, requiredOutputTraits);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STATE_0_CLOSED{

            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        @Override
        public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
            SqlNode sqlNode;
            SqlParser parser = SqlParser.create(PlannerImpl.this.parserFactory, queryString, PlannerImpl.this.parserConfig);
            try {
                sqlNode = parser.parseQuery();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed", e);
            }
            Prepare.CatalogReader catalogReader = PlannerImpl.this.createCatalogReader().withSchemaPath((List)schemaPath);
            OptiqSqlValidator validator = PlannerImpl.this.createSqlValidator((OptiqCatalogReader)catalogReader);
            SqlNode validatedSqlNode = validator.validate(sqlNode);
            SqlToRelConverter sqlToRelConverter = PlannerImpl.this.getSqlToRelConverter(validator, (OptiqCatalogReader)catalogReader);
            RelNode relNode = sqlToRelConverter.convertQuery(validatedSqlNode, true, false);
            relNode = sqlToRelConverter.flattenTypes(relNode, true);
            relNode = sqlToRelConverter.decorrelate(validatedSqlNode, relNode);
            return relNode;
        }
    }
}

