/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.jdbc.OptiqSchema$FunctionEntry;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptiqSchema {
    public final Schema schema;
    public final String name;
    protected final OptiqSchema parent;
    private ImmutableList<ImmutableList<String>> path;

    public OptiqSchema(OptiqSchema parent, Schema schema, String name) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
    }

    public abstract TableEntry add(String var1, Table var2);

    public abstract OptiqSchema getSubSchema(String var1, boolean var2);

    public abstract OptiqSchema add(String var1, Schema var2);

    public abstract Pair<String, Table> getTable(String var1, boolean var2);

    public abstract Collection<TableEntry> getTableEntries();

    public abstract Set<String> getSubSchemaNames();

    public abstract Collection<OptiqSchema> getSubSchemas();

    public abstract Set<String> getTableNames();

    public abstract Collection<Function> getFunctions(String var1, boolean var2);

    public abstract Map<String, Table> getTablesBasedOnNullaryFunctions();

    public abstract Pair<String, Table> getTableBasedOnNullaryFunction(String var1, boolean var2);

    protected abstract OptiqSchema$FunctionEntry add(String var1, Function var2);

    public String getName() {
        return this.name;
    }

    public OptiqSchema root() {
        OptiqSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return schema;
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static OptiqSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).optiqSchema();
    }

    public List<String> path(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        OptiqSchema s = this;
        while (s != null) {
            if (s.parent != null || !s.name.equals("")) {
                list.add(s.name);
            }
            s = s.parent;
        }
        return ImmutableList.copyOf(Lists.reverse(list));
    }

    protected void setCache(boolean cache) {
        throw new UnsupportedOperationException("Schema doesn't support caching.");
    }

    public List<? extends List<String>> getPath() {
        if (this.path != null) {
            return this.path;
        }
        return ImmutableList.of(this.path(null));
    }

    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(OptiqSchema schema, String name, Table table) {
            super(schema, name);
            assert (table != null);
            this.table = table;
        }

        public Table getTable() {
            return this.table;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SchemaPlusImpl
    implements SchemaPlus {
        protected SchemaPlusImpl() {
        }

        public OptiqSchema optiqSchema() {
            return OptiqSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return OptiqSchema.this.parent == null ? null : OptiqSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return OptiqSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return OptiqSchema.this.schema.isMutable();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            OptiqSchema.this.setCache(cache);
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return OptiqSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Table getTable(String name) {
            Pair<String, Table> pair = OptiqSchema.this.getTable(name, true);
            return pair == null ? null : (Table)pair.getValue();
        }

        @Override
        public Set<String> getTableNames() {
            return OptiqSchema.this.getTableNames();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            OptiqSchema subSchema = OptiqSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return OptiqSchema.this.getSubSchemaNames();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            OptiqSchema optiqSchema = OptiqSchema.this.add(name, schema);
            return optiqSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(OptiqSchema.this)) {
                return clazz.cast(OptiqSchema.this);
            }
            if (clazz.isInstance(OptiqSchema.this.schema)) {
                return clazz.cast(OptiqSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            OptiqSchema.this.path = path;
        }

        @Override
        public void add(String name, Table table) {
            OptiqSchema.this.add(name, table);
        }

        @Override
        public void add(String name, Function function) {
            OptiqSchema.this.add(name, function);
        }
    }

    public static abstract class TableEntry
    extends Entry {
        public TableEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Table getTable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        public final OptiqSchema schema;
        public final String name;

        public Entry(OptiqSchema schema, String name) {
            Linq4j.requireNonNull(schema);
            Linq4j.requireNonNull(name);
            this.schema = schema;
            this.name = name;
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }
}

