/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.avatica.AvaticaParameter;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Cursor;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.EnumerableDefaults;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.ClassDeclaration;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqPrepare$ParseResult;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.runtime.ArrayEnumeratorCursor;
import net.hydromatic.optiq.runtime.Bindable;
import net.hydromatic.optiq.runtime.ObjectEnumeratorCursor;
import net.hydromatic.optiq.runtime.RecordEnumeratorCursor;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.util.Stacks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OptiqPrepare {
    public static final Function0<OptiqPrepare> DEFAULT_FACTORY = new Function0<OptiqPrepare>(){

        @Override
        public OptiqPrepare apply() {
            return new OptiqPrepareImpl();
        }
    };
    public static final ThreadLocal<ArrayList<Context>> THREAD_CONTEXT_STACK = new ThreadLocal<ArrayList<Context>>(){

        @Override
        protected ArrayList<Context> initialValue() {
            return new ArrayList<Context>();
        }
    };

    public OptiqPrepare$ParseResult parse(Context var1, String var2);

    public <T> PrepareResult<T> prepareSql(Context var1, String var2, Queryable<T> var3, Type var4, int var5);

    public <T> PrepareResult<T> prepareQueryable(Context var1, Queryable<T> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrepareResult<T>
    implements AvaticaPrepareResult {
        public final String sql;
        public final List<AvaticaParameter> parameterList;
        public final RelDataType rowType;
        public final ColumnMetaData.StructType structType;
        private final int maxRowCount;
        private final Bindable<T> bindable;
        public final Class resultClazz;

        public PrepareResult(String sql, List<AvaticaParameter> parameterList, RelDataType rowType, ColumnMetaData.StructType structType, int maxRowCount, Bindable<T> bindable, Class resultClazz) {
            this.sql = sql;
            this.parameterList = parameterList;
            this.rowType = rowType;
            this.structType = structType;
            this.maxRowCount = maxRowCount;
            this.bindable = bindable;
            this.resultClazz = resultClazz;
        }

        public Cursor createCursor(DataContext dataContext) {
            Enumerator<Object> enumerator = this.enumerator(dataContext);
            return this.structType.columns.size() == 1 ? new ObjectEnumeratorCursor(enumerator) : (this.resultClazz != null && !this.resultClazz.isArray() ? new RecordEnumeratorCursor<Object>(enumerator, this.resultClazz) : new ArrayEnumeratorCursor((Enumerator<Object[]>)enumerator));
        }

        @Override
        public List<ColumnMetaData> getColumnList() {
            return this.structType.columns;
        }

        @Override
        public List<AvaticaParameter> getParameterList() {
            return this.parameterList;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        private Enumerable<T> getEnumerable(DataContext dataContext) {
            Enumerable<T> enumerable = this.bindable.bind(dataContext);
            if (this.maxRowCount >= 0) {
                enumerable = EnumerableDefaults.take(enumerable, this.maxRowCount);
            }
            return enumerable;
        }

        public Enumerator<T> enumerator(DataContext dataContext) {
            return this.getEnumerable(dataContext).enumerator();
        }

        public Iterator<T> iterator(DataContext dataContext) {
            return this.getEnumerable(dataContext).iterator();
        }
    }

    public static class Dummy {
        private static SparkHandler sparkHandler;

        public static synchronized SparkHandler getSparkHandler(boolean enable) {
            if (sparkHandler == null) {
                sparkHandler = enable ? Dummy.createHandler() : new TrivialSparkHandler();
            }
            return sparkHandler;
        }

        private static SparkHandler createHandler() {
            try {
                Class<?> clazz = Class.forName("net.hydromatic.optiq.impl.spark.SparkHandlerImpl");
                Method method = clazz.getMethod("instance", new Class[0]);
                return (SparkHandler)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                return new TrivialSparkHandler();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static void push(Context context) {
            Stacks.push((List)THREAD_CONTEXT_STACK.get(), context);
        }

        public static Context peek() {
            return (Context)Stacks.peek((List)THREAD_CONTEXT_STACK.get());
        }

        public static void pop(Context context) {
            Stacks.pop((List)THREAD_CONTEXT_STACK.get(), context);
        }

        private static class TrivialSparkHandler
        implements SparkHandler {
            private TrivialSparkHandler() {
            }

            public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
                return rootRel;
            }

            public void registerRules(SparkHandler.RuleSetBuilder builder) {
            }

            public boolean enabled() {
                return false;
            }

            public Bindable compile(ClassDeclaration expr, String s) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface SparkHandler {
        public RelNode flattenTypes(RelOptPlanner var1, RelNode var2, boolean var3);

        public void registerRules(RuleSetBuilder var1);

        public boolean enabled();

        public Bindable compile(ClassDeclaration var1, String var2);

        public static interface RuleSetBuilder {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Context {
        public JavaTypeFactory getTypeFactory();

        public OptiqSchema getRootSchema();

        public List<String> getDefaultSchemaPath();

        public OptiqConnectionConfig config();

        public SparkHandler spark();

        public DataContext getDataContext();
    }
}

