/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.java;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.java.ReflectiveSchema$ReflectiveTable$1;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveSchema
extends AbstractSchema {
    final Class clazz;
    private Object target;

    public String toString() {
        return "ReflectiveSchema(target=" + this.target + ")";
    }

    @Override
    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder<String, Table> builder = ImmutableMap.builder();
        for (Field field : this.clazz.getFields()) {
            String fieldName = field.getName();
            Table table = this.fieldRelation(field);
            if (table == null) continue;
            builder.put(fieldName, table);
        }
        return builder.build();
    }

    Expression getTargetExpression(SchemaPlus parentSchema, String name) {
        return Types.castIfNecessary(this.target.getClass(), Expressions.call(Schemas.unwrap(this.getExpression(parentSchema, name), ReflectiveSchema.class), BuiltinMethod.REFLECTIVE_SCHEMA_GET_TARGET.method, new Expression[0]));
    }

    private <T> Table fieldRelation(Field field) {
        Object o;
        Type elementType = ReflectiveSchema.getElementType(field.getType());
        if (elementType == null) {
            return null;
        }
        try {
            o = field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while accessing field " + field, e);
        }
        Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
        return new FieldTable(field, elementType, enumerable);
    }

    private static Type getElementType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    private static Enumerable toEnumerable(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return Linq4j.asEnumerable((Object[])o);
            }
            return Linq4j.asEnumerable(Primitive.asList(o));
        }
        if (o instanceof Iterable) {
            return Linq4j.asEnumerable((Iterable)o);
        }
        throw new RuntimeException("Cannot convert " + o.getClass() + " into a Enumerable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldTable<T>
    extends ReflectiveTable {
        private final Field field;

        public FieldTable(Field field, Type elementType, Enumerable<T> enumerable) {
            super(elementType, enumerable);
            this.field = field;
        }

        public String toString() {
            return "Relation {field=" + this.field.getName() + "}";
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Expressions.field(schema.unwrap(ReflectiveSchema.class).getTargetExpression(schema.getParentSchema(), schema.getName()), this.field);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectiveTable
    extends AbstractQueryableTable
    implements Table {
        private final Type elementType;
        private final Enumerable enumerable;

        public ReflectiveTable(Type elementType, Enumerable enumerable) {
            super(elementType);
            this.elementType = elementType;
            this.enumerable = enumerable;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new ReflectiveSchema$ReflectiveTable$1(this, queryProvider, schema, this, tableName);
        }

        static /* synthetic */ Enumerable access$000(ReflectiveTable x0) {
            return x0.enumerable;
        }
    }
}

