/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.ViewTable$ViewTableMacro;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.util.Util;

public class ViewTable
extends AbstractQueryableTable {
    private final String viewSql;
    private final List schemaPath;
    private final RelProtoDataType protoRowType;

    public ViewTable(Type type, RelProtoDataType relProtoDataType, String string, List list) {
        super(type);
        this.viewSql = string;
        this.schemaPath = ImmutableList.copyOf(list);
        this.protoRowType = relProtoDataType;
    }

    public static ViewTable$ViewTableMacro viewMacro(SchemaPlus schemaPlus, String string, List list) {
        return new ViewTable$ViewTableMacro(OptiqSchema.from(schemaPlus), string, list);
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        return (RelDataType)this.protoRowType.apply(relDataTypeFactory);
    }

    public Queryable asQueryable(QueryProvider queryProvider, SchemaPlus schemaPlus, String string) {
        return queryProvider.createQuery(this.getExpression(schemaPlus, string, Queryable.class), this.elementType);
    }

    public RelNode toRel(RelOptTable.ToRelContext toRelContext, RelOptTable relOptTable) {
        return this.expandView(toRelContext, relOptTable.getRowType(), this.viewSql);
    }

    private RelNode expandView(RelOptTable.ToRelContext toRelContext, RelDataType relDataType, String string) {
        try {
            RelNode relNode = toRelContext.expandView(relDataType, string, this.schemaPath);
            relNode = RelOptUtil.createCastRel(relNode, relDataType, true);
            return relNode;
        }
        catch (Throwable throwable) {
            throw Util.newInternal(throwable, "Error while parsing view definition:  " + string);
        }
    }
}

