/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.impl.ReflectiveFunctionBase$1;

public abstract class ReflectiveFunctionBase {
    public final Method method;
    public final List parameters;

    public ReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(method.getParameterTypes());
    }

    public List getParameters() {
        return this.parameters;
    }

    public static ImmutableList toFunctionParameters(Class ... classArray) {
        return ReflectiveFunctionBase.toFunctionParameters(Arrays.asList(classArray));
    }

    public static ImmutableList toFunctionParameters(Iterable iterable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int n = 0;
        for (Class clazz : iterable) {
            int n2 = n++;
            builder.add(new ReflectiveFunctionBase$1(n2, clazz));
        }
        return builder.build();
    }

    static boolean classHasPublicZeroArgsConstructor(Class clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || (constructor.getModifiers() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class clazz, String string) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }
}

