/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas$1;
import net.hydromatic.optiq.Schemas$2;
import net.hydromatic.optiq.Schemas$DummyDataContext;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schemas {
    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static Expression expression(SchemaPlus schema) {
        return schema.getExpression(schema.getParentSchema(), schema.getName());
    }

    public static Expression subSchemaExpression(SchemaPlus schema, String name, Class type) {
        Expression schemaExpression = Schemas.expression(schema);
        MethodCallExpression call = Expressions.call(schemaExpression, BuiltinMethod.SCHEMA_GET_SUB_SCHEMA.method, Expressions.constant(name));
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_(Expressions.call(call, BuiltinMethod.SCHEMA_PLUS_UNWRAP.method, Expressions.constant(type)), type);
    }

    public static Expression tableExpression(SchemaPlus schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression = Table.class.isAssignableFrom(clazz) ? Expressions.call(Schemas.expression(schema), BuiltinMethod.SCHEMA_GET_TABLE.method, Expressions.constant(tableName)) : Expressions.call(BuiltinMethod.SCHEMAS_QUERYABLE.method, DataContext.ROOT, Schemas.expression(schema), Expressions.constant(elementType), Expressions.constant(tableName));
        return Types.castIfNecessary(clazz, expression);
    }

    public static DataContext createDataContext(Connection connection) {
        return new Schemas$DummyDataContext((OptiqConnection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.ParseResult parse(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath);
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    public static OptiqPrepare.PrepareResult<Object> prepare(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        return prepare.prepareSql(Schemas.makeContext(connection, schema, schemaPath), sql, null, (Type)((Object)Object[].class), -1);
    }

    private static OptiqPrepare.Context makeContext(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath) {
        if (connection == null) {
            OptiqPrepare.Context context0 = OptiqPrepare.Dummy.peek();
            return Schemas.makeContext(context0.config(), context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath);
        }
        return Schemas.makeContext(connection.config(), connection.getTypeFactory(), Schemas.createDataContext(connection), schema, schemaPath);
    }

    private static OptiqPrepare.Context makeContext(OptiqConnectionConfig connectionConfig, JavaTypeFactory typeFactory, DataContext dataContext, OptiqSchema schema, List<String> schemaPath) {
        return new Schemas$1(typeFactory, schema, schemaPath, connectionConfig, dataContext);
    }

    public static RelProtoDataType proto(Table table) {
        return new Schemas$2(table);
    }

    public static RelProtoDataType proto(final ScalarFunction function) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return function.getReturnType(typeFactory);
            }
        };
    }
}

