/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.function.BigDecimalFunction1;
import net.hydromatic.linq4j.function.DoubleFunction1;
import net.hydromatic.linq4j.function.EqualityComparer;
import net.hydromatic.linq4j.function.FloatFunction1;
import net.hydromatic.linq4j.function.Function;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.linq4j.function.IntegerFunction1;
import net.hydromatic.linq4j.function.LongFunction1;
import net.hydromatic.linq4j.function.NullableBigDecimalFunction1;
import net.hydromatic.linq4j.function.NullableDoubleFunction1;
import net.hydromatic.linq4j.function.NullableFloatFunction1;
import net.hydromatic.linq4j.function.NullableIntegerFunction1;
import net.hydromatic.linq4j.function.NullableLongFunction1;
import net.hydromatic.linq4j.function.Predicate1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Functions {
    public static final Map<Class<? extends Function>, Class> FUNCTION_RESULT_TYPES = Collections.unmodifiableMap(Functions.map(Function0.class, Object.class, Function1.class, Object.class, Function2.class, Object.class, BigDecimalFunction1.class, BigDecimal.class, DoubleFunction1.class, Double.TYPE, FloatFunction1.class, Float.TYPE, IntegerFunction1.class, Integer.TYPE, LongFunction1.class, Long.TYPE, NullableBigDecimalFunction1.class, BigDecimal.class, NullableDoubleFunction1.class, Double.class, NullableFloatFunction1.class, Float.class, NullableIntegerFunction1.class, Integer.class, NullableLongFunction1.class, Long.class));
    private static final Map<Class, Class<? extends Function>> FUNCTION1_CLASSES = Collections.unmodifiableMap(new HashMap<Class, Class<? extends Function>>(Functions.inverse(FUNCTION_RESULT_TYPES)));
    private static final Comparator NULLS_FIRST_COMPARATOR = new NullsFirstComparator();
    private static final Comparator NULLS_LAST_COMPARATOR = new NullsLastComparator();
    private static final Comparator NULLS_LAST_REVERSE_COMPARATOR = new NullsLastReverseComparator();
    private static final Comparator NULLS_FIRST_REVERSE_COMPARATOR = new NullsFirstReverseComparator();
    private static final EqualityComparer<Object> IDENTITY_COMPARER = new IdentityEqualityComparer();
    private static final EqualityComparer<Object[]> ARRAY_COMPARER = new ArrayEqualityComparer();
    private static final Function1 CONSTANT_NULL_FUNCTION1 = new Function1(){

        public Object apply(Object s) {
            return null;
        }
    };

    private Functions() {
    }

    private static <K, V> Map<K, V> map(K k, V v, Object ... rest) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(k, v);
        for (int i = 0; i < rest.length; ++i) {
            map.put(rest[i++], rest[i++]);
        }
        return map;
    }

    private static <K, V> Map<V, K> inverse(Map<K, V> map) {
        HashMap<V, K> inverseMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }

    public static <T> Predicate1<T> truePredicate1() {
        return Predicate1.TRUE;
    }

    public static <TSource> Function1<TSource, TSource> identitySelector() {
        return Function1.IDENTITY;
    }

    public static <T1, R> List<R> adapt(final List<T1> list, final Function1<T1, R> f) {
        return new AbstractList<R>(){

            @Override
            public Object get(int index) {
                return f.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T, R> List<R> adapt(final T[] ts, final Function1<T, R> f) {
        return new AbstractList<R>(){

            @Override
            public Object get(int index) {
                return f.apply(ts[index]);
            }

            @Override
            public int size() {
                return ts.length;
            }
        };
    }

    public static <E> List<E> filter(List<E> list, Predicate1<E> predicate) {
        block8: {
            int hitCount = 0;
            int missCount = 0;
            for (E e : list) {
                if (predicate.apply(e)) {
                    if (missCount <= 0) {
                        ++hitCount;
                        continue;
                    }
                } else if (hitCount <= 0) {
                    ++missCount;
                    continue;
                }
                break block8;
            }
            if (hitCount == 0) {
                return Collections.emptyList();
            }
            if (missCount == 0) {
                return list;
            }
        }
        ArrayList<E> list2 = new ArrayList<E>(list.size());
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public static <R, T0, T1> Function2<R, T0, T1> ignore2() {
        return Ignore.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Ignore<R, T0, T1>
    implements Function0<R>,
    Function1<T0, R>,
    Function2<T0, T1, R> {
        static final Ignore INSTANCE = new Ignore();

        private Ignore() {
        }

        @Override
        public Object apply() {
            return null;
        }

        @Override
        public Object apply(Object p0) {
            return null;
        }

        @Override
        public Object apply(Object p0, Object p1) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastReverseComparator
    implements Serializable,
    Comparator<Comparable> {
        private NullsLastReverseComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstReverseComparator
    implements Serializable,
    Comparator<Comparable> {
        private NullsFirstReverseComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return -o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastComparator
    implements Serializable,
    Comparator<Comparable> {
        private NullsLastComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstComparator
    implements Serializable,
    Comparator<Comparable> {
        private NullsFirstComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityEqualityComparer
    implements EqualityComparer<Object> {
        private IdentityEqualityComparer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayEqualityComparer
    implements EqualityComparer<Object[]> {
        private ArrayEqualityComparer() {
        }
    }
}

