/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String name;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;

    public MethodDeclaration(int modifier, String name, Type resultType, List<ParameterExpression> parameters, BlockStatement body) {
        assert (name != null) : "name should not be null";
        assert (resultType != null) : "resultType should not be null";
        assert (parameters != null) : "parameters should not be null";
        assert (body != null) : "body should not be null";
        this.modifier = modifier;
        this.name = name;
        this.resultType = resultType;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        BlockStatement body = this.body.accept(visitor);
        return visitor.visit(this, body);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).append(' ').append(this.name).list("(", ", ", ")", Functions.adapt(this.parameters, new Function1<ParameterExpression, String>(){

            public String apply(ParameterExpression a0) {
                return a0.declString();
            }
        })).append(' ').append(this.body);
        writer.newlineAndIndent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDeclaration that = (MethodDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        int result = this.modifier;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.resultType.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.body.hashCode();
        return result;
    }
}

