/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantExpression
extends Expression {
    public final Object value;

    public ConstantExpression(Type type, Object value) {
        super(ExpressionType.Constant, type);
        this.value = value;
        if (value != null && type instanceof Class) {
            Class clazz = (Class)type;
            Primitive primitive = Primitive.of(clazz);
            if (primitive != null) {
                clazz = primitive.boxClass;
            }
            if (!clazz.isInstance(value)) {
                throw new AssertionError((Object)("value " + value + " does not match type " + type));
            }
        }
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        return this.value;
    }

    @Override
    public Expression accept(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (this.value == null) {
            if (!writer.requireParentheses(this, lprec, rprec)) {
                writer.append("(").append(this.type).append(") null");
            }
            return;
        }
        ConstantExpression.write(writer, this.value, this.type);
    }

    private static ExpressionWriter write(ExpressionWriter writer, final Object value, Type type) {
        if (value == null) {
            return writer.append("null");
        }
        if (type == null && Primitive.isBox(type = value.getClass())) {
            type = Primitive.ofBox(type).primitiveClass;
        }
        if (value instanceof String) {
            ConstantExpression.escapeString(writer.getBuf(), (String)value);
            return writer;
        }
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            switch (primitive) {
                case BYTE: {
                    return writer.append("(byte)").append(((Byte)value).intValue());
                }
                case CHAR: {
                    return writer.append("(char)").append((Object)((Character)value).charValue());
                }
                case SHORT: {
                    return writer.append("(short)").append(((Short)value).intValue());
                }
                case LONG: {
                    return writer.append(value).append("L");
                }
                case FLOAT: {
                    return writer.append(value).append("F");
                }
                case DOUBLE: {
                    return writer.append(value).append("D");
                }
            }
            return writer.append(value);
        }
        Primitive primitive2 = Primitive.ofBox(type);
        if (primitive2 != null) {
            writer.append(primitive2.boxClass.getSimpleName() + ".valueOf(");
            ConstantExpression.write(writer, value, primitive2.primitiveClass);
            return writer.append(")");
        }
        if (value instanceof Enum) {
            return writer.append(((Enum)value).getDeclaringClass()).append('.').append(((Enum)value).name());
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)value).stripTrailingZeros();
            try {
                int scale = bigDecimal.scale();
                long exact = bigDecimal.scaleByPowerOfTen(scale).longValueExact();
                writer.append("new java.math.BigDecimal(").append(exact).append("L");
                if (scale != 0) {
                    writer.append(", ").append(scale);
                }
                return writer.append(")");
            }
            catch (ArithmeticException e) {
                return writer.append("new java.math.BigDecimal(\"").append(bigDecimal.toString()).append("\")");
            }
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return writer.append("new java.math.BigInteger(\"").append(bigInteger.toString()).append("\")");
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return writer.append(clazz.getCanonicalName()).append(".class");
        }
        if (value instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)value;
            return writer.append(recordType.getName()).append(".class");
        }
        if (value.getClass().isArray()) {
            writer.append("new ").append(value.getClass().getComponentType());
            ConstantExpression.list(writer, Primitive.asList(value), "[] {\n", ",\n", "}");
            return writer;
        }
        Constructor constructor = ConstantExpression.matchingConstructor(value);
        if (constructor != null) {
            Field[] fields = value.getClass().getFields();
            writer.append("new ").append(value.getClass());
            ConstantExpression.list(writer, Functions.adapt(fields, new Function1<Field, Object>(){

                public Object apply(Field field) {
                    try {
                        return field.get(value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }), "(\n", ",\n", ")");
            return writer;
        }
        return writer.append(value);
    }

    private static void list(ExpressionWriter writer, List list, String begin, String sep, String end) {
        writer.begin(begin);
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (i > 0) {
                writer.append(sep).indent();
            }
            ConstantExpression.write(writer, value, null);
        }
        writer.end(end);
    }

    private static Constructor matchingConstructor(Object value) {
        Field[] fields = value.getClass().getFields();
        for (Constructor<?> constructor : value.getClass().getConstructors()) {
            if (!ConstantExpression.argsMatchFields(fields, constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }

    private static boolean argsMatchFields(Field[] fields, Class<?>[] parameterTypes) {
        if (parameterTypes.length != fields.length) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getType() == parameterTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static void escapeString(StringBuilder buf, String s) {
        buf.append('\"');
        int n = s.length();
        int lastChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    if (lastChar == 10) break;
                    buf.append("\\r");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
        }
        buf.append('\"');
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

