/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.expressions.ClassDeclaration;
import net.hydromatic.linq4j.expressions.DeterministicCodeOptimizer;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.function.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclarationFinder
extends Visitor {
    protected final ClassDeclarationFinder parent;
    protected final List<MemberDeclaration> addedDeclarations = new ArrayList<MemberDeclaration>();
    private final Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory;
    private static final Function1<ClassDeclarationFinder, ClassDeclarationFinder> DEFAULT_CHILD_FACTORY = new Function1<ClassDeclarationFinder, ClassDeclarationFinder>(){

        public ClassDeclarationFinder apply(ClassDeclarationFinder a0) {
            return new DeterministicCodeOptimizer(a0);
        }
    };

    public static ClassDeclarationFinder create() {
        return ClassDeclarationFinder.create(DEFAULT_CHILD_FACTORY);
    }

    public static ClassDeclarationFinder create(Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory) {
        return new ClassDeclarationFinder(childFactory);
    }

    private ClassDeclarationFinder(Function1<ClassDeclarationFinder, ClassDeclarationFinder> childFactory) {
        this.parent = null;
        this.childFactory = childFactory;
    }

    protected ClassDeclarationFinder(ClassDeclarationFinder parent) {
        this.parent = parent;
        this.childFactory = parent.childFactory;
    }

    @Override
    public Visitor preVisit(NewExpression newExpression) {
        if (newExpression.memberDeclarations == null) {
            return this;
        }
        ClassDeclarationFinder visitor = this.goDeeper();
        visitor.learnFinalStaticDeclarations(newExpression.memberDeclarations);
        return visitor;
    }

    @Override
    public Visitor preVisit(ClassDeclaration classDeclaration) {
        ClassDeclarationFinder visitor = this.goDeeper();
        visitor.learnFinalStaticDeclarations(classDeclaration.memberDeclarations);
        return visitor;
    }

    @Override
    public Expression visit(NewExpression newExpression, List<Expression> arguments, List<MemberDeclaration> memberDeclarations) {
        if (this.parent == null) {
            arguments = newExpression.arguments;
        } else if (memberDeclarations != null) {
            arguments = Expressions.acceptExpressions(newExpression.arguments, this.parent);
        }
        Expression result = super.visit(newExpression, arguments, memberDeclarations);
        if (memberDeclarations == null) {
            return this.tryOptimizeNewInstance((NewExpression)result);
        }
        memberDeclarations = this.optimizeDeclarations(memberDeclarations);
        return super.visit((NewExpression)result, arguments, memberDeclarations);
    }

    protected void learnFinalStaticDeclarations(List<MemberDeclaration> memberDeclarations) {
    }

    protected Expression tryOptimizeNewInstance(NewExpression newExpression) {
        return newExpression;
    }

    @Override
    public ClassDeclaration visit(ClassDeclaration classDeclaration, List<MemberDeclaration> memberDeclarations) {
        memberDeclarations = this.optimizeDeclarations(memberDeclarations);
        return super.visit(classDeclaration, memberDeclarations);
    }

    protected List<MemberDeclaration> optimizeDeclarations(List<MemberDeclaration> memberDeclarations) {
        if (this.addedDeclarations.isEmpty()) {
            return memberDeclarations;
        }
        ArrayList<MemberDeclaration> newDecls = new ArrayList<MemberDeclaration>(memberDeclarations.size() + this.addedDeclarations.size());
        newDecls.addAll(memberDeclarations);
        newDecls.addAll(this.addedDeclarations);
        return newDecls;
    }

    protected boolean isConstant(Expression expression) {
        return false;
    }

    protected boolean isConstant(Iterable<? extends Expression> list) {
        for (Expression expression : list) {
            if (this.isConstant(expression)) continue;
            return false;
        }
        return true;
    }

    protected ParameterExpression findDeclaredExpression(Expression expression) {
        return null;
    }

    protected boolean hasField(String name) {
        return false;
    }

    protected ClassDeclarationFinder goDeeper() {
        return (ClassDeclarationFinder)this.childFactory.apply(this);
    }
}

