/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.AbstractEnumerable2;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.QueryProviderImpl;
import net.hydromatic.linq4j.Queryable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Linq4j {
    private static final Object DUMMY = new Object();
    private static final Method AUTO_CLOSEABLE_CLOSE_METHOD = Linq4j.getMethod("java.lang.AutoCloseable", "close", new Class[0]);
    public static final QueryProvider DEFAULT_PROVIDER = new QueryProviderImpl(){

        @Override
        public <T> Enumerator<T> executeQuery(Queryable<T> queryable) {
            return queryable.enumerator();
        }
    };
    private static final Enumerator<Object> EMPTY_ENUMERATOR = new Enumerator<Object>(){

        @Override
        public Object current() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean moveNext() {
            return false;
        }

        @Override
        public void close() {
        }
    };
    public static final Enumerable<?> EMPTY_ENUMERABLE = new AbstractEnumerable<Object>(){

        @Override
        public Enumerator<Object> enumerator() {
            return EMPTY_ENUMERATOR;
        }
    };

    private Linq4j() {
    }

    public static Method getMethod(String className, String methodName, Class ... parameterTypes) {
        try {
            return Class.forName(className).getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Iterator<T> enumeratorIterator(final Enumerator<T> enumerator) {
        return new Iterator<T>(){
            boolean hasNext;
            {
                this.hasNext = enumerator.moveNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Object next() {
                Object t = enumerator.current();
                this.hasNext = enumerator.moveNext();
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Enumerator<T> iterableEnumerator(Iterable<T> iterable) {
        return new IterableEnumerator<T>(iterable);
    }

    public static <T> Enumerable<T> asEnumerable(List<T> list) {
        return new ListEnumerable<T>(list);
    }

    public static <T> Enumerable<T> asEnumerable(Collection<T> collection) {
        if (collection instanceof List) {
            return Linq4j.asEnumerable((List)collection);
        }
        return new CollectionEnumerable<T>(collection);
    }

    public static <T> Enumerable<T> asEnumerable(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return Linq4j.asEnumerable((Collection)iterable);
        }
        return new IterableEnumerable<T>(iterable);
    }

    public static <T> Enumerable<T> asEnumerable(T[] ts) {
        return new ListEnumerable<T>(Arrays.asList(ts));
    }

    public static <V> Enumerator<V> enumerator(Collection<V> values) {
        return Linq4j.iterableEnumerator(values);
    }

    public static <T> Enumerable<T> singletonEnumerable(final T element) {
        return new AbstractEnumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                return Linq4j.singletonEnumerator(element);
            }
        };
    }

    public static <T> Enumerator<T> singletonEnumerator(T element) {
        return new SingletonEnumerator(element);
    }

    public static <T> Enumerator<T> emptyEnumerator() {
        return EMPTY_ENUMERATOR;
    }

    public static <E> Enumerable<E> concat(List<Enumerable<E>> enumerableList) {
        return new CompositeEnumerable<E>(enumerableList);
    }

    public static <T> boolean equals(T t0, T t1) {
        return t0 == t1 || t0 != null && t0.equals(t1);
    }

    public static <T> T requireNonNull(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonEnumerator<E>
    implements Enumerator<E> {
        final Object e;
        int i = 0;

        SingletonEnumerator(Object e) {
            this.e = e;
        }

        @Override
        public Object current() {
            return this.e;
        }

        @Override
        public boolean moveNext() {
            return this.i++ == 0;
        }

        @Override
        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListEnumerable<T>
    extends CollectionEnumerable<T> {
        ListEnumerable(Collection<T> iterable) {
            super(iterable);
        }

        @Override
        public List<T> toList() {
            return (List)this.iterable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionEnumerable<T>
    extends IterableEnumerable<T> {
        CollectionEnumerable(Collection<T> iterable) {
            super(iterable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterableEnumerable<T>
    extends AbstractEnumerable2<T> {
        protected final Iterable<T> iterable;

        IterableEnumerable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterable.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompositeEnumerable<E>
    extends AbstractEnumerable<E> {
        private final Enumerator<Enumerable<E>> enumerableEnumerator;

        CompositeEnumerable(List<Enumerable<E>> enumerableList) {
            this.enumerableEnumerator = Linq4j.iterableEnumerator(enumerableList);
        }

        @Override
        public Enumerator<E> enumerator() {
            return new Enumerator<E>(){
                Enumerator<E> current = Linq4j.emptyEnumerator();

                @Override
                public Object current() {
                    return this.current.current();
                }

                @Override
                public boolean moveNext() {
                    while (!this.current.moveNext()) {
                        this.current.close();
                        if (!CompositeEnumerable.this.enumerableEnumerator.moveNext()) {
                            this.current = Linq4j.emptyEnumerator();
                            return false;
                        }
                        this.current = ((Enumerable)CompositeEnumerable.this.enumerableEnumerator.current()).enumerator();
                    }
                    return true;
                }

                @Override
                public void close() {
                    this.current.close();
                    this.current = Linq4j.emptyEnumerator();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterableEnumerator<T>
    implements Enumerator<T> {
        private final Iterable<T> iterable;
        Iterator<T> iterator;
        Object current;

        public IterableEnumerator(Iterable<T> iterable) {
            this.iterable = iterable;
            this.iterator = iterable.iterator();
            this.current = DUMMY;
        }

        @Override
        public Object current() {
            if (this.current == DUMMY) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public boolean moveNext() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            this.current = DUMMY;
            return false;
        }

        @Override
        public void close() {
            Iterator<T> iterator = this.iterator;
            this.iterator = null;
            if (AUTO_CLOSEABLE_CLOSE_METHOD != null) {
                if (AUTO_CLOSEABLE_CLOSE_METHOD.getDeclaringClass().isInstance(iterator)) {
                    try {
                        AUTO_CLOSEABLE_CLOSE_METHOD.invoke(iterator, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getCause());
                    }
                }
            } else {
                if (iterator instanceof Closeable) {
                    try {
                        ((Closeable)((Object)iterator)).close();
                        return;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (iterator instanceof ResultSet) {
                    try {
                        ((ResultSet)((Object)iterator)).close();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }
}

