/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TreeMap;
import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.LookupImpl;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.linq4j.function.Predicate2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumerableDefaults {
    public static <TSource> Enumerable<TSource> concat(Enumerable<TSource> enumerable0, Enumerable<TSource> enumerable1) {
        return Linq4j.concat(Arrays.asList(enumerable0, enumerable1));
    }

    public static <TSource, TKey extends Comparable> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.orderBy(source, keySelector, null);
    }

    public static <TSource, TKey> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        TreeMap map = new TreeMap(comparator);
        LookupImpl lookup = EnumerableDefaults.toLookup_(map, source, keySelector, Functions.identitySelector());
        return lookup.valuesEnumerable();
    }

    public static <TSource, TResult> Enumerable<TResult> select(final Enumerable<TSource> source, final Function1<TSource, TResult> selector) {
        if (selector == Functions.identitySelector()) {
            return source;
        }
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> enumerator;
                    {
                        this.enumerator = source.enumerator();
                    }

                    @Override
                    public Object current() {
                        return selector.apply(this.enumerator.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.enumerator.moveNext();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function1<TSource, Enumerable<TResult>> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public Object current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            this.resultEnumerator = ((Enumerable)selector.apply(this.sourceEnumerator.current())).enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource> Enumerable<TSource> take(Enumerable<TSource> source, final int count) {
        return EnumerableDefaults.takeWhile(source, new Predicate2<TSource, Integer>(){

            public boolean apply(TSource v1, Integer v2) {
                return v2 < count;
            }
        });
    }

    public static <TSource> Enumerable<TSource> takeWhile(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new TakeWhileEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource> List<TSource> toList(Enumerable<TSource> source) {
        if (source instanceof List && source instanceof RandomAccess) {
            return (List)((Object)source);
        }
        return source.into(source instanceof Collection ? new ArrayList(((Collection)((Object)source)).size()) : new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <TSource, TKey, TElement> LookupImpl<TKey, TElement> toLookup_(Map<TKey, List<TElement>> map, Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                Object key = keySelector.apply(o);
                List<Object> list = map.get(key);
                if (list == null) {
                    list = Collections.singletonList(elementSelector.apply(o));
                } else {
                    if (list.size() == 1) {
                        Object element = list.get(0);
                        list = new ArrayList();
                        list.add(element);
                    }
                    list.add(elementSelector.apply(o));
                }
                map.put(key, list);
            }
        }
        finally {
            os.close();
        }
        return new LookupImpl<TKey, TElement>(map);
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate1<TSource> predicate) {
        assert (predicate != null);
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                final Enumerator enumerator = source.enumerator();
                return new Enumerator<TSource>(){

                    @Override
                    public Object current() {
                        return enumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (enumerator.moveNext()) {
                            if (!predicate.apply(enumerator.current())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void close() {
                        enumerator.close();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<? super T>> C into(Enumerable<T> source, C sink) {
        Enumerator enumerator = source.enumerator();
        try {
            while (enumerator.moveNext()) {
                Object t = enumerator.current();
                sink.add((Object)t);
            }
        }
        finally {
            enumerator.close();
        }
        return sink;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TakeWhileEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Integer> predicate;
        boolean done = false;
        int n = -1;

        public TakeWhileEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Integer> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public Object current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            if (!this.done) {
                if (this.enumerator.moveNext() && this.predicate.apply(this.enumerator.current(), ++this.n)) {
                    return true;
                }
                this.done = true;
            }
            return false;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }
}

