/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler;

import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.compiler.CompileError;
import javassist.compiler.JvstCodeGen;
import javassist.compiler.JvstTypeChecker;
import javassist.compiler.Lex;
import javassist.compiler.Parser;
import javassist.compiler.ProceedHandler;
import javassist.compiler.SymbolTable;
import javassist.compiler.ast.ASTList;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.CallExpr;
import javassist.compiler.ast.Expr;
import javassist.compiler.ast.Member;
import javassist.compiler.ast.Stmnt;

public class Javac {
    JvstCodeGen gen;
    SymbolTable stable;
    private Bytecode bytecode;

    public Javac(CtClass thisClass) {
        this(new Bytecode(thisClass.getClassFile2().getConstPool(), 0, 0), thisClass);
    }

    public Javac(Bytecode b, CtClass thisClass) {
        this.gen = new JvstCodeGen(b, thisClass, thisClass.getClassPool());
        this.stable = new SymbolTable();
        this.bytecode = b;
    }

    public Bytecode compileBody(CtBehavior method, String src) throws CompileError {
        try {
            boolean isVoid;
            CtClass rtype;
            int mod = method.getModifiers();
            this.recordParams(method.getParameterTypes(), Modifier.isStatic(mod));
            if (method instanceof CtMethod) {
                this.gen.setThisMethod((CtMethod)method);
                rtype = ((CtMethod)method).getReturnType();
            } else {
                rtype = CtClass.voidType;
            }
            this.recordReturnType(rtype, false);
            boolean bl = isVoid = rtype == CtClass.voidType;
            if (src == null) {
                Javac.makeDefaultBody(this.bytecode, rtype);
            } else {
                Parser p = new Parser(new Lex(src));
                SymbolTable stb = new SymbolTable(this.stable);
                Stmnt s = p.parseStatement(stb);
                if (p.hasMore()) {
                    throw new CompileError("the method/constructor body must be surrounded by {}");
                }
                boolean callSuper = false;
                if (method instanceof CtConstructor) {
                    callSuper = !((CtConstructor)method).isClassInitializer();
                }
                this.gen.atMethodBody(s, callSuper, isVoid);
            }
            return this.bytecode;
        }
        catch (NotFoundException e) {
            throw new CompileError(e.toString());
        }
    }

    private static void makeDefaultBody(Bytecode b, CtClass type) {
        int value;
        int op;
        if (type instanceof CtPrimitiveType) {
            CtPrimitiveType pt = (CtPrimitiveType)type;
            op = pt.getReturnOp();
            value = op == 175 ? 14 : (op == 174 ? 11 : (op == 173 ? 9 : (op == 177 ? 0 : 3)));
        } else {
            op = 176;
            value = 1;
        }
        if (value != 0) {
            b.addOpcode(value);
        }
        b.addOpcode(op);
    }

    public int recordParams(CtClass[] params, boolean isStatic) throws CompileError {
        return this.gen.recordParams(params, isStatic, "$", "$args", "$$", this.stable);
    }

    public int recordReturnType(CtClass type, boolean useResultVar) throws CompileError {
        this.gen.recordType(type);
        return this.gen.recordReturnType(type, "$r", useResultVar ? "$_" : null, this.stable);
    }

    public void recordProceed(String target, String method) throws CompileError {
        Parser p = new Parser(new Lex(target));
        final ASTree texpr = p.parseExpression(this.stable);
        final String m = method;
        ProceedHandler h = new ProceedHandler(){

            public void doit(JvstCodeGen gen, Bytecode b, ASTList args) throws CompileError {
                ASTree expr = new Member(m);
                if (texpr != null) {
                    expr = Expr.make(46, texpr, expr);
                }
                expr = CallExpr.makeCall(expr, args);
                gen.compileExpr(expr);
                gen.addNullIfVoid();
            }

            public void setReturnType(JvstTypeChecker check, ASTList args) throws CompileError {
                ASTree expr = new Member(m);
                if (texpr != null) {
                    expr = Expr.make(46, texpr, expr);
                }
                expr = CallExpr.makeCall(expr, args);
                ((ASTree)expr).accept(check);
                check.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler(h, "$proceed");
    }
}

