/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class SignatureAttribute
extends AttributeInfo {
    SignatureAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public SignatureAttribute(ConstPool cp, String signature) {
        super(cp, "Signature");
        int index = cp.addUtf8Info(signature);
        byte[] bvalue = new byte[]{(byte)(index >>> 8), (byte)index};
        this.set(bvalue);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    public void setSignature(String sig) {
        int index = this.getConstPool().addUtf8Info(sig);
        ByteArray.write16bit(index, this.info, 0);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        return new SignatureAttribute(newCp, this.getSignature());
    }

    void renameClass(String oldname, String newname) {
        String sig = SignatureAttribute.renameClass(this.getSignature(), oldname, newname);
        this.setSignature(sig);
    }

    void renameClass(Map classnames) {
        String sig = SignatureAttribute.renameClass(this.getSignature(), classnames);
        this.setSignature(sig);
    }

    static String renameClass(String desc, String oldname, String newname) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(oldname, newname);
        return SignatureAttribute.renameClass(desc, map);
    }

    static String renameClass(String desc, Map map) {
        int j;
        if (map == null) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        int head = 0;
        int i = 0;
        while ((j = desc.indexOf(76, i)) >= 0) {
            char c;
            StringBuilder nameBuf = new StringBuilder();
            int k = j;
            try {
                while ((c = desc.charAt(++k)) != ';') {
                    nameBuf.append(c);
                    if (c != '<') continue;
                    while ((c = desc.charAt(++k)) != '>') {
                        nameBuf.append(c);
                    }
                    nameBuf.append(c);
                }
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            i = k + 1;
            String name = nameBuf.toString();
            String name2 = (String)map.get(name);
            if (name2 == null) continue;
            newdesc.append(desc.substring(head, j));
            newdesc.append('L');
            newdesc.append(name2);
            newdesc.append(c);
            head = i;
        }
        if (head == 0) {
            return desc;
        }
        int len = desc.length();
        if (head < len) {
            newdesc.append(desc.substring(head, len));
        }
        return newdesc.toString();
    }
}

