/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Formatter;

public final class StringUtil {
    public static final String NEWLINE;
    private static final String[] BYTE2HEX_PAD;
    private static final String[] BYTE2HEX_NOPAD;

    public static String simpleClassName(Object o) {
        if (o == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(o.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        if (clazz == null) {
            return "null_class";
        }
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            return clazz.getName().substring(pkg.getName().length() + 1);
        }
        return clazz.getName();
    }

    private StringUtil() {
    }

    static {
        StringBuilder buf;
        int i;
        String newLine;
        BYTE2HEX_PAD = new String[256];
        BYTE2HEX_NOPAD = new String[256];
        try {
            newLine = new Formatter().format("%n", new Object[0]).toString();
        }
        catch (Exception e) {
            newLine = "\n";
        }
        NEWLINE = newLine;
        for (i = 0; i < 10; ++i) {
            buf = new StringBuilder(2);
            buf.append('0');
            buf.append(i);
            StringUtil.BYTE2HEX_PAD[i] = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i] = String.valueOf(i);
        }
        while (i < 16) {
            buf = new StringBuilder(2);
            char c = (char)(97 + i - 10);
            buf.append('0');
            buf.append(c);
            StringUtil.BYTE2HEX_PAD[i] = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i] = String.valueOf(c);
            ++i;
        }
        while (i < BYTE2HEX_PAD.length) {
            String str;
            buf = new StringBuilder(2);
            buf.append(Integer.toHexString(i));
            StringUtil.BYTE2HEX_PAD[i] = str = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i] = str;
            ++i;
        }
    }
}

