/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ReferenceCounted;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static boolean release(Object msg) {
        if (msg instanceof ReferenceCounted) {
            return ((ReferenceCounted)msg).release();
        }
        return false;
    }

    public static void safeRelease(Object msg) {
        try {
            ReferenceCountUtil.release(msg);
        }
        catch (Throwable t) {
            logger.warn("Failed to release a message: {}", msg, t);
        }
    }

    private ReferenceCountUtil() {
    }
}

