/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final InternalLogger logger;

    private NetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static {
        NetUtil.logger = InternalLoggerFactory.getInstance(NetUtil.class);
        LOCALHOST4_BYTES = new byte[]{127, 0, 0, 1};
        LOCALHOST6_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        localhost4 = null;
        try {
            localhost4 = (Inet4Address)InetAddress.getByAddress(LOCALHOST4_BYTES);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
        }
        NetUtil.LOCALHOST4 = localhost4;
        localhost6 = null;
        try {
            localhost6 = (Inet6Address)InetAddress.getByAddress(LOCALHOST6_BYTES);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
        }
        NetUtil.LOCALHOST6 = localhost6;
        ifaces = new ArrayList<NetworkInterface>();
        try {
            i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                iface = i.nextElement();
                if (!iface.getInetAddresses().hasMoreElements()) continue;
                ifaces.add(iface);
            }
        }
        catch (SocketException e) {
            NetUtil.logger.warn("Failed to retrieve the list of available network interfaces", e);
        }
        loopbackIface = null;
        loopbackAddr = null;
        block25: for (NetworkInterface iface : ifaces) {
            i = iface.getInetAddresses();
            while (i.hasMoreElements()) {
                addr = i.nextElement();
                if (!addr.isLoopbackAddress()) continue;
                loopbackIface = iface;
                loopbackAddr = addr;
                break block25;
            }
        }
        if (loopbackIface == null) {
            try {
                for (NetworkInterface iface : ifaces) {
                    if (!iface.isLoopback() || !(i = iface.getInetAddresses()).hasMoreElements()) continue;
                    loopbackIface = iface;
                    loopbackAddr = i.nextElement();
                    break;
                }
                if (loopbackIface == null) {
                    NetUtil.logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException e) {
                NetUtil.logger.warn("Failed to find the loopback interface", e);
            }
        }
        if (loopbackIface != null) {
            NetUtil.logger.debug("Loopback interface: {} ({}, {})", new Object[]{loopbackIface.getName(), loopbackIface.getDisplayName(), loopbackAddr.getHostAddress()});
        } else if (loopbackAddr == null) {
            try {
                if (NetworkInterface.getByInetAddress(NetUtil.LOCALHOST6) != null) {
                    NetUtil.logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)localhost6);
                    loopbackAddr = localhost6;
                }
            }
            catch (Exception e) {
            }
            finally {
                if (loopbackAddr == null) {
                    NetUtil.logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)localhost4);
                    loopbackAddr = localhost4;
                }
            }
        }
        NetUtil.LOOPBACK_IF = loopbackIface;
        NetUtil.LOCALHOST = loopbackAddr;
        somaxconn = PlatformDependent.isWindows() != false ? 200 : 128;
        file = new File("/proc/sys/net/core/somaxconn");
        if (file.exists()) {
            in = null;
            try {
                in = new BufferedReader(new FileReader(file));
                somaxconn = Integer.parseInt(in.readLine());
                if (!NetUtil.logger.isDebugEnabled()) ** GOTO lbl94
                NetUtil.logger.debug("{}: {}", (Object)file, (Object)somaxconn);
            }
            catch (Exception e) {
                NetUtil.logger.debug("Failed to get SOMAXCONN from: {}", (Object)file, (Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception var10_19) {}
                }
            }
        } else if (NetUtil.logger.isDebugEnabled()) {
            NetUtil.logger.debug("{}: {} (non-existent)", (Object)file, (Object)somaxconn);
        }
lbl94:
        // 6 sources

        NetUtil.SOMAXCONN = somaxconn;
    }
}

