/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

public final class UnsafeDirectLittleEndian
extends WrappedByteBuf {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private final PooledUnsafeDirectByteBuf wrapped;
    private final long memoryAddress;

    UnsafeDirectLittleEndian(PooledUnsafeDirectByteBuf buf) {
        super(buf);
        if (!NATIVE_ORDER || buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Drill only runs on LittleEndian systems.");
        }
        this.wrapped = buf;
        this.memoryAddress = buf.memoryAddress();
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Override
    public long getLong(int index) {
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public short getShort(int index) {
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.wrapped.checkIndex(index, 2);
        this._setShort(index, value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.wrapped.checkIndex(index, 4);
        this._setInt(index, value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.wrapped.checkIndex(index, 8);
        this._setLong(index, value);
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.wrapped.ensureWritable(2);
        this._setShort(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.wrapped.ensureWritable(4);
        this._setInt(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.wrapped.ensureWritable(8);
        this._setLong(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 8;
        return this;
    }

    private void _setShort(int index, int value) {
        PlatformDependent.putShort(this.addr(index), (short)value);
    }

    private void _setInt(int index, int value) {
        PlatformDependent.putInt(this.addr(index), value);
    }

    private void _setLong(int index, long value) {
        PlatformDependent.putLong(this.addr(index), value);
    }

    @Override
    public byte getByte(int index) {
        return PlatformDependent.getByte(this.addr(index));
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }
}

