/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Parseable;
import java.io.File;
import java.net.URL;
import java.util.Properties;

public final class ConfigFactory {
    public static Config load(String string) {
        return ConfigFactory.load(string, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public static Config load(ClassLoader classLoader, String string) {
        return ConfigFactory.load(string, ConfigParseOptions.defaults().setClassLoader(classLoader), ConfigResolveOptions.defaults());
    }

    public static Config load(String string, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        Config config = ConfigFactory.parseResourcesAnySyntax(string, configParseOptions);
        return ConfigFactory.load(configParseOptions.getClassLoader(), config, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.defaultOverrides(classLoader).withFallback(config).withFallback(ConfigFactory.defaultReference(classLoader)).resolve(configResolveOptions);
    }

    public static Config defaultReference(ClassLoader classLoader) {
        return ConfigImpl.defaultReference(classLoader);
    }

    public static Config defaultOverrides(ClassLoader classLoader) {
        return ConfigFactory.systemProperties();
    }

    public static Config systemProperties() {
        return ConfigImpl.systemPropertiesAsConfig();
    }

    public static Config parseProperties(Properties properties, ConfigParseOptions configParseOptions) {
        return Parseable.newProperties(properties, configParseOptions).parse().toConfig();
    }

    public static Config parseProperties(Properties properties) {
        return ConfigFactory.parseProperties(properties, ConfigParseOptions.defaults());
    }

    public static Config parseURL(URL uRL, ConfigParseOptions configParseOptions) {
        return Parseable.newURL(uRL, configParseOptions).parse().toConfig();
    }

    public static Config parseURL(URL uRL) {
        return ConfigFactory.parseURL(uRL, ConfigParseOptions.defaults());
    }

    public static Config parseFileAnySyntax(File file, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseFileAnySyntax(file, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(String string, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(string, configParseOptions).toConfig();
    }
}

