/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.ConfigOrigin;
import java.io.Serializable;

public abstract class ConfigException
extends RuntimeException
implements Serializable {
    private final transient ConfigOrigin origin;

    protected ConfigException(ConfigOrigin configOrigin, String string, Throwable throwable) {
        super(configOrigin.description() + ": " + string, throwable);
        this.origin = configOrigin;
    }

    protected ConfigException(String string, Throwable throwable) {
        super(string, throwable);
        this.origin = null;
    }

    public static class Generic
    extends ConfigException {
        public Generic(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class ValidationFailed
    extends ConfigException {
        private final Iterable<ValidationProblem> problems;

        public ValidationFailed(Iterable<ValidationProblem> iterable) {
            super(ValidationFailed.makeMessage(iterable), null);
            this.problems = iterable;
        }

        private static String makeMessage(Iterable<ValidationProblem> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValidationProblem validationProblem : iterable) {
                stringBuilder.append(validationProblem.origin().description());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.path());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.problem());
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() == 0) {
                throw new BugOrBroken("ValidationFailed must have a non-empty list of problems");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            return stringBuilder.toString();
        }
    }

    public static class ValidationProblem {
        private final String path;
        private final ConfigOrigin origin;
        private final String problem;

        public ValidationProblem(String string, ConfigOrigin configOrigin, String string2) {
            this.path = string;
            this.origin = configOrigin;
            this.problem = string2;
        }

        public String path() {
            return this.path;
        }

        public ConfigOrigin origin() {
            return this.origin;
        }

        public String problem() {
            return this.problem;
        }
    }

    public static class NotResolved
    extends BugOrBroken {
        public NotResolved(String string, Throwable throwable) {
            super(string, throwable);
        }

        public NotResolved(String string) {
            this(string, null);
        }
    }

    public static class UnresolvedSubstitution
    extends Parse {
        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, "Could not resolve substitution to a value: " + string, throwable);
        }

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class Parse
    extends ConfigException {
        public Parse(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        public Parse(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class IO
    extends ConfigException {
        public IO(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        public IO(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class BugOrBroken
    extends ConfigException {
        public BugOrBroken(String string, Throwable throwable) {
            super(string, throwable);
        }

        public BugOrBroken(String string) {
            this(string, null);
        }
    }

    public static class BadPath
    extends ConfigException {
        public BadPath(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, string != null ? "Invalid path '" + string + "': " + string2 : string2, throwable);
        }

        public BadPath(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }
    }

    public static class BadValue
    extends ConfigException {
        public BadValue(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, "Invalid value at '" + string + "': " + string2, throwable);
        }

        public BadValue(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }
    }

    public static class Null
    extends Missing {
        private static String makeMessage(String string, String string2) {
            if (string2 != null) {
                return "Configuration key '" + string + "' is set to null but expected " + string2;
            }
            return "Configuration key '" + string + "' is null";
        }

        public Null(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, Null.makeMessage(string, string2), throwable);
        }

        public Null(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }
    }

    public static class Missing
    extends ConfigException {
        public Missing(String string, Throwable throwable) {
            super("No configuration setting found for key '" + string + "'", throwable);
        }

        public Missing(String string) {
            this(string, null);
        }

        protected Missing(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }
    }

    public static class WrongType
    extends ConfigException {
        public WrongType(ConfigOrigin configOrigin, String string, String string2, String string3, Throwable throwable) {
            super(configOrigin, string + " has type " + string3 + " rather than " + string2, throwable);
        }

        public WrongType(ConfigOrigin configOrigin, String string, String string2, String string3) {
            this(configOrigin, string, string2, string3, null);
        }

        public WrongType(ConfigOrigin configOrigin, String string) {
            super(configOrigin, string, null);
        }
    }
}

