/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.Types;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;

public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType = this.capture();

    protected TypeToken() {
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", this.runtimeType);
    }

    public final Class<? super T> getRawType() {
        Class<?> rawType;
        Class<?> result = rawType = TypeToken.getRawType(this.runtimeType);
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TypeToken) {
            TypeToken that = (TypeToken)o;
            return this.runtimeType.equals(that.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    static Class<?> getRawType(Type type) {
        return (Class)TypeToken.getRawTypes(type).iterator().next();
    }

    static ImmutableSet<Class<?>> getRawTypes(Type type) {
        if (type instanceof Class) {
            return ImmutableSet.of((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ImmutableSet.of((Class)parameterizedType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return ImmutableSet.of(Types.getArrayClass(TypeToken.getRawType(genericArrayType.getGenericComponentType())));
        }
        if (type instanceof TypeVariable) {
            return TypeToken.getRawTypes(((TypeVariable)type).getBounds());
        }
        if (type instanceof WildcardType) {
            return TypeToken.getRawTypes(((WildcardType)type).getUpperBounds());
        }
        throw new AssertionError((Object)(type + " unsupported"));
    }

    private static ImmutableSet<Class<?>> getRawTypes(Type[] types) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Type type : types) {
            builder.addAll(TypeToken.getRawTypes(type));
        }
        return builder.build();
    }

    private static enum TypeFilter implements Predicate<TypeToken<?>>
    {
        IGNORE_TYPE_VARIABLE_OR_WILDCARD{

            public boolean apply(TypeToken<?> type) {
                return !(((TypeToken)type).runtimeType instanceof TypeVariable) && !(((TypeToken)type).runtimeType instanceof WildcardType);
            }
        }
        ,
        INTERFACE_ONLY{

            public boolean apply(TypeToken<?> type) {
                return type.getRawType().isInterface();
            }
        };

    }
}

