/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;

public final class Funnels {

    private static enum LongFunnel implements Funnel<Long>
    {
        INSTANCE;


        @Override
        public void funnel(Long from, PrimitiveSink into) {
            into.putLong(from);
        }

        public String toString() {
            return "Funnels.longFunnel()";
        }
    }

    private static enum IntegerFunnel implements Funnel<Integer>
    {
        INSTANCE;


        @Override
        public void funnel(Integer from, PrimitiveSink into) {
            into.putInt(from);
        }

        public String toString() {
            return "Funnels.integerFunnel()";
        }
    }

    private static enum StringFunnel implements Funnel<CharSequence>
    {
        INSTANCE;


        @Override
        public void funnel(CharSequence from, PrimitiveSink into) {
            into.putString(from);
        }

        public String toString() {
            return "Funnels.stringFunnel()";
        }
    }

    private static enum ByteArrayFunnel implements Funnel<byte[]>
    {
        INSTANCE;


        @Override
        public void funnel(byte[] from, PrimitiveSink into) {
            into.putBytes(from);
        }

        public String toString() {
            return "Funnels.byteArrayFunnel()";
        }
    }
}

