/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.cfg.JaxRSFeature;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.util.ClassKey;
import com.fasterxml.jackson.jaxrs.util.LRUMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

public abstract class ProviderBase<THIS extends ProviderBase<THIS, MAPPER, EP_CONFIG, MAPPER_CONFIG>, MAPPER extends ObjectMapper, EP_CONFIG extends Object<EP_CONFIG>, MAPPER_CONFIG extends MapperConfiguratorBase<MAPPER_CONFIG, MAPPER>>
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    protected static final HashSet<ClassKey> DEFAULT_UNTOUCHABLES = new HashSet();
    public static final Class<?>[] DEFAULT_UNREADABLES;
    public static final Class<?>[] DEFAULT_UNWRITABLES;
    protected static final int JAXRS_FEATURE_DEFAULTS;
    protected final MapperConfiguratorBase _mapperConfig;
    protected boolean _cfgCheckCanSerialize = false;
    protected boolean _cfgCheckCanDeserialize = false;
    protected int _jaxRSFeatures;
    public static final HashSet<ClassKey> _untouchables;
    public static final Class<?>[] _unreadableClasses;
    public static final Class<?>[] _unwritableClasses;
    protected final LRUMap<Object, EP_CONFIG> _readers = new LRUMap(16, 120);
    protected final LRUMap<Object, EP_CONFIG> _writers = new LRUMap(16, 120);
    protected final AtomicReference<IOException> _noContentExceptionRef = new AtomicReference();

    protected ProviderBase(MapperConfiguratorBase mconfig) {
        this._mapperConfig = mconfig;
        this._jaxRSFeatures = JAXRS_FEATURE_DEFAULTS;
    }

    public void setMapper(ObjectMapper m) {
        this._mapperConfig.setMapper(m);
    }

    static {
        DEFAULT_UNTOUCHABLES.add(new ClassKey(InputStream.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(Reader.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(OutputStream.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(Writer.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(char[].class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(String.class));
        DEFAULT_UNTOUCHABLES.add(new ClassKey(byte[].class));
        DEFAULT_UNREADABLES = new Class[]{InputStream.class, Reader.class};
        DEFAULT_UNWRITABLES = new Class[]{InputStream.class, OutputStream.class, Writer.class, StreamingOutput.class, Response.class};
        JAXRS_FEATURE_DEFAULTS = JaxRSFeature.collectDefaults();
        _untouchables = DEFAULT_UNTOUCHABLES;
        _unreadableClasses = DEFAULT_UNREADABLES;
        _unwritableClasses = DEFAULT_UNWRITABLES;
    }
}

