/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class EnumMapSerializer
extends ContainerSerializer<EnumMap<? extends Enum<?>, ?>>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final BeanProperty _property;
    protected final EnumValues _keyEnums;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    public EnumMapSerializer(JavaType valueType, boolean staticTyping, EnumValues keyEnums, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(EnumMap.class, false);
        this._property = null;
        this._staticTyping = staticTyping || valueType != null && valueType.isFinal();
        this._valueType = valueType;
        this._keyEnums = keyEnums;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
    }

    public EnumMapSerializer(EnumMapSerializer src, BeanProperty property, JsonSerializer<?> ser) {
        super(src);
        this._property = property;
        this._staticTyping = src._staticTyping;
        this._valueType = src._valueType;
        this._keyEnums = src._keyEnums;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._valueSerializer = ser;
    }

    public EnumMapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return new EnumMapSerializer(this._valueType, this._staticTyping, this._keyEnums, vts, this._valueSerializer);
    }

    public EnumMapSerializer withValueSerializer(BeanProperty prop, JsonSerializer<?> ser) {
        if (this._property == prop && ser == this._valueSerializer) {
            return this;
        }
        return new EnumMapSerializer(this, prop, ser);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if (ser == null) {
            if (this._staticTyping) {
                return this.withValueSerializer(property, provider.findValueSerializer(this._valueType, property));
            }
        } else if (this._valueSerializer instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(provider, property);
        }
        if (ser != this._valueSerializer) {
            return this.withValueSerializer(property, ser);
        }
        return this;
    }

    public boolean isEmpty(EnumMap<? extends Enum<?>, ?> value) {
        return value == null || value.isEmpty();
    }

    public boolean hasSingleElement(EnumMap<? extends Enum<?>, ?> value) {
        return value.size() == 1;
    }

    @Override
    public void serialize(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            this.serializeContents(value, jgen, provider);
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, jgen);
        if (!value.isEmpty()) {
            this.serializeContents(value, jgen, provider);
        }
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    protected void serializeContents(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._valueSerializer != null) {
            this.serializeContentsUsing(value, jgen, provider, this._valueSerializer);
            return;
        }
        JsonSerializer<Object> prevSerializer = null;
        Class<?> prevClass = null;
        EnumValues keyEnums = this._keyEnums;
        for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Enum<?> key = entry.getKey();
            if (keyEnums == null) {
                StdSerializer ser = (StdSerializer)provider.findValueSerializer(key.getDeclaringClass(), this._property);
                keyEnums = ((EnumSerializer)ser).getEnumValues();
            }
            jgen.writeFieldName(keyEnums.serializedValueFor(key));
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevClass) {
                currSerializer = prevSerializer;
            } else {
                prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                prevClass = cc;
            }
            try {
                currSerializer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, entry.getKey().name());
            }
        }
    }

    protected void serializeContentsUsing(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> valueSer) throws IOException, JsonGenerationException {
        EnumValues keyEnums = this._keyEnums;
        for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
            Enum<?> key = entry.getKey();
            if (keyEnums == null) {
                StdSerializer ser = (StdSerializer)provider.findValueSerializer(key.getDeclaringClass(), this._property);
                keyEnums = ((EnumSerializer)ser).getEnumValues();
            }
            jgen.writeFieldName(keyEnums.serializedValueFor(key));
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            try {
                valueSer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, entry.getKey().name());
            }
        }
    }
}

