/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import java.io.DataOutput;
import java.io.IOException;

public final class LinkedBuffer {
    final byte[] buffer;
    final int start;
    int offset;
    LinkedBuffer next;

    public static int writeTo(DataOutput out, LinkedBuffer node) throws IOException {
        int contentSize = 0;
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            out.write(node.buffer, node.start, len);
            contentSize += len;
        } while ((node = node.next) != null);
        return contentSize;
    }

    LinkedBuffer(int size) {
        this(new byte[size], 0, 0);
    }

    LinkedBuffer(int size, LinkedBuffer appendTarget) {
        this(new byte[size], 0, 0, appendTarget);
    }

    LinkedBuffer(byte[] buffer, int start, int offset) {
        this.buffer = buffer;
        this.start = start;
        this.offset = offset;
    }

    LinkedBuffer(byte[] buffer, int offset, LinkedBuffer appendTarget) {
        this(buffer, offset, offset);
        appendTarget.next = this;
    }

    LinkedBuffer(byte[] buffer, int start, int offset, LinkedBuffer appendTarget) {
        this(buffer, start, offset);
        appendTarget.next = this;
    }

    LinkedBuffer(LinkedBuffer viewSource, LinkedBuffer appendTarget) {
        this.buffer = viewSource.buffer;
        this.offset = this.start = viewSource.offset;
        appendTarget.next = this;
    }
}

