/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StatefulOutput;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonOutput
implements Output,
StatefulOutput {
    private final JsonGenerator generator;
    private Schema<?> schema;
    private final boolean numeric;
    private boolean lastRepeated;
    private int lastNumber;

    public JsonOutput(JsonGenerator generator, boolean numeric) {
        this.generator = generator;
        this.numeric = numeric;
    }

    public JsonOutput(JsonGenerator generator, boolean numeric, Schema<?> schema) {
        this(generator, numeric);
        this.schema = schema;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    @Override
    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBoolean(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBoolean(value);
        } else {
            generator.writeBooleanField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBinary(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBinary(value);
        } else {
            generator.writeFieldName(name);
            generator.writeBinary(value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    @Override
    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    @Override
    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    @Override
    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeString(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeString(value);
        } else {
            generator.writeStringField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    @Override
    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        JsonGenerator generator = this.generator;
        Schema<?> lastSchema = this.schema;
        if (this.lastNumber != fieldNumber) {
            String name;
            if (this.lastRepeated) {
                generator.writeEndArray();
            }
            String string = name = this.numeric ? Integer.toString(fieldNumber) : lastSchema.getFieldName(fieldNumber);
            if (repeated) {
                generator.writeArrayFieldStart(name);
            } else {
                generator.writeFieldName(name);
            }
        }
        this.schema = schema;
        this.lastNumber = 0;
        this.lastRepeated = false;
        generator.writeStartObject();
        schema.writeTo(this, value);
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
        this.schema = lastSchema;
    }
}

