/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.StringSerializer;

public final class ByteString {
    private final byte[] bytes;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteString EMPTY = new ByteString(EMPTY_BYTE_ARRAY);
    private volatile int hash = 0;

    static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toStringUtf8();
    }

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new ByteString(copy);
    }

    public String toStringUtf8() {
        return StringSerializer.STRING.deser(this.bytes);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ByteString && ByteString.equals(this, (ByteString)o, false);
    }

    public static boolean equals(ByteString bs, ByteString other, boolean checkHash) {
        int size = bs.bytes.length;
        if (size != other.bytes.length) {
            return false;
        }
        if (checkHash) {
            int h1 = bs.hash;
            int h2 = other.hash;
            if (h1 != 0 && h2 != 0 && h1 != h2) {
                return false;
            }
        }
        byte[] thisBytes = bs.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int size;
            byte[] thisBytes = this.bytes;
            h = size = this.bytes.length;
            for (int i = 0; i < size; ++i) {
                h = h * 31 + thisBytes[i];
            }
            if (h == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }
}

