/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Long>> gauges = new HashMap<String, Gauge<Long>>();
        gauges.put("total.init", new Gauge<Long>(){});
        gauges.put("total.used", new Gauge<Long>(){});
        gauges.put("total.max", new Gauge<Long>(){});
        gauges.put("total.committed", new Gauge<Long>(){});
        gauges.put("heap.init", new Gauge<Long>(){});
        gauges.put("heap.used", new Gauge<Long>(){});
        gauges.put("heap.max", new Gauge<Long>(){});
        gauges.put("heap.committed", new Gauge<Long>(){});
        gauges.put("heap.usage", new RatioGauge(){});
        gauges.put("non-heap.init", new Gauge<Long>(){});
        gauges.put("non-heap.used", new Gauge<Long>(){});
        gauges.put("non-heap.max", new Gauge<Long>(){});
        gauges.put("non-heap.committed", new Gauge<Long>(){});
        gauges.put("non-heap.usage", new RatioGauge(){});
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            gauges.put(MetricRegistry.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("-"), "usage"), new RatioGauge(){});
        }
        return Collections.unmodifiableMap(gauges);
    }
}

