/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.Iterator;

public class IntIntOpenHashMap
implements IntIntMap,
Cloneable {
    public int[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public IntIntOpenHashMap() {
        this(16);
    }

    public IntIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public int put(int key, int value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0;
    }

    private void expandAndRehash() {
        int[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            int key = oldKeys[i];
            int value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new int[capacity];
        this.values = new int[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public int get(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public boolean containsKey(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public int size() {
        return this.assigned;
    }

    public int hashCode() {
        int h = 0;
        for (IntIntCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            IntIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntIntMap && (other = (IntIntMap)obj).size() == this.size()) {
                for (IntIntCursor c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<IntIntCursor> iterator() {
        return new EntryIterator();
    }

    public IntIntOpenHashMap clone() {
        try {
            IntIntOpenHashMap cloned = (IntIntOpenHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    private final class EntryIterator
    extends AbstractIterator<IntIntCursor> {
        private final IntIntCursor cursor = new IntIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntIntCursor fetch() {
            int i;
            int max = IntIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !IntIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntIntOpenHashMap.this.keys[i];
            this.cursor.value = IntIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

