/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;

public final class BoundedProportionalArraySizingStrategy
implements ArraySizingStrategy {
    public final int minGrowCount;
    public final int maxGrowCount;
    public final float growRatio;

    public BoundedProportionalArraySizingStrategy() {
        this(10, Integer.MAX_VALUE, 1.5f);
    }

    public BoundedProportionalArraySizingStrategy(int minGrow, int maxGrow, float ratio) {
        assert (minGrow >= 1) : "Min grow must be >= 1.";
        assert (maxGrow >= minGrow) : "Max grow must be >= min grow.";
        assert (ratio >= 1.0f) : "Growth ratio must be >= 1 (was " + ratio + ").";
        this.minGrowCount = minGrow;
        this.maxGrowCount = maxGrow;
        this.growRatio = ratio - 1.0f;
    }

    @Override
    public int grow(int currentBufferLength, int elementsCount, int expectedAdditions) {
        assert ((long)elementsCount + (long)expectedAdditions <= Integer.MAX_VALUE) : "Cannot resize beyond 2147483647 (" + (elementsCount + expectedAdditions) + ")";
        int growBy = (int)Math.min((long)((float)currentBufferLength * this.growRatio), Integer.MAX_VALUE);
        growBy = Math.max(this.minGrowCount, growBy);
        growBy = Math.min(this.maxGrowCount, growBy);
        growBy = Math.max(elementsCount + expectedAdditions, currentBufferLength + growBy);
        return growBy;
    }

    @Override
    public int round(int capacity) {
        assert (capacity >= 0) : "Capacity must be a positive number.";
        return capacity;
    }
}

