/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FlushNonReferential;
import org.datanucleus.FlushOrdered;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.types.queued.SCOOperationQueue;

public class FlushReferential
extends FlushOrdered {
    public List<NucleusOptimisticException> execute(ExecutionContext ec, List<ObjectProvider> primaryOPs, List<ObjectProvider> secondaryOPs, SCOOperationQueue scoQueue) {
        List excps;
        ObjectProvider op;
        Iterator<ObjectProvider> opIter;
        List flushExcps = null;
        HashSet<ObjectProvider> unrelatedOPs = null;
        if (primaryOPs != null) {
            opIter = primaryOPs.iterator();
            while (opIter.hasNext()) {
                op = opIter.next();
                if (op.isEmbedded() || !this.isClassSuitableForBatching(ec, op.getClassMetaData())) continue;
                if (unrelatedOPs == null) {
                    unrelatedOPs = new HashSet<ObjectProvider>();
                }
                unrelatedOPs.add(op);
                opIter.remove();
            }
        }
        if (secondaryOPs != null) {
            opIter = secondaryOPs.iterator();
            while (opIter.hasNext()) {
                op = opIter.next();
                if (op.isEmbedded() || !this.isClassSuitableForBatching(ec, op.getClassMetaData())) continue;
                if (unrelatedOPs == null) {
                    unrelatedOPs = new HashSet();
                }
                unrelatedOPs.add(op);
                opIter.remove();
            }
        }
        if (unrelatedOPs != null) {
            FlushNonReferential groupedFlush = new FlushNonReferential();
            flushExcps = groupedFlush.flushDeleteInsertUpdateGrouped(unrelatedOPs, ec);
        }
        if ((excps = super.execute(ec, primaryOPs, secondaryOPs, scoQueue)) != null) {
            if (flushExcps == null) {
                flushExcps = excps;
            } else {
                flushExcps.addAll(excps);
            }
        }
        return flushExcps;
    }

    private boolean isClassSuitableForBatching(ExecutionContext ec, AbstractClassMetaData cmd) {
        if (cmd.hasRelations(ec.getClassLoaderResolver(), ec.getMetaDataManager())) {
            return false;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)ec.getStoreManager();
        ClassTable table = (ClassTable)storeMgr.getDatastoreClass(cmd.getFullClassName(), ec.getClassLoaderResolver());
        do {
            if (this.isTableSuitableForBatching(table)) continue;
            return false;
        } while ((table = (ClassTable)table.getSuperDatastoreClass()) != null);
        return true;
    }

    private boolean isTableSuitableForBatching(ClassTable table) {
        if (table.hasExternalFkMappings()) {
            return false;
        }
        return !table.isObjectIdDatastoreAttributed();
    }
}

