/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.yarn;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.sasl.SaslRpcHandler;
import org.apache.spark.network.sasl.ShuffleSecretManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.network.yarn.util.HadoopConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnShuffleService
extends AuxiliaryService {
    private final Logger logger = LoggerFactory.getLogger(YarnShuffleService.class);
    private static final String SPARK_SHUFFLE_SERVICE_PORT_KEY = "spark.shuffle.service.port";
    private static final int DEFAULT_SPARK_SHUFFLE_SERVICE_PORT = 7337;
    private static final String SPARK_AUTHENTICATE_KEY = "spark.authenticate";
    private static final boolean DEFAULT_SPARK_AUTHENTICATE = false;
    private ShuffleSecretManager secretManager;
    private TransportServer shuffleServer = null;

    public YarnShuffleService() {
        super("spark_shuffle");
        this.logger.info("Initializing YARN shuffle service for Spark");
    }

    private boolean isAuthenticationEnabled() {
        return this.secretManager != null;
    }

    protected void serviceInit(Configuration conf) {
        TransportConf transportConf = new TransportConf(new HadoopConfigProvider(conf));
        boolean authEnabled = conf.getBoolean(SPARK_AUTHENTICATE_KEY, false);
        RpcHandler rpcHandler = new ExternalShuffleBlockHandler(transportConf);
        if (authEnabled) {
            this.secretManager = new ShuffleSecretManager();
            rpcHandler = new SaslRpcHandler(rpcHandler, this.secretManager);
        }
        int port = conf.getInt(SPARK_SHUFFLE_SERVICE_PORT_KEY, 7337);
        TransportContext transportContext = new TransportContext(transportConf, rpcHandler);
        this.shuffleServer = transportContext.createServer(port);
        String authEnabledString = authEnabled ? "enabled" : "not enabled";
        this.logger.info("Started YARN shuffle service for Spark on port {}. Authentication is {}.", (Object)port, (Object)authEnabledString);
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String appId = context.getApplicationId().toString();
        try {
            ByteBuffer shuffleSecret = context.getApplicationDataForService();
            this.logger.info("Initializing application {}", (Object)appId);
            if (this.isAuthenticationEnabled()) {
                this.secretManager.registerApp(appId, shuffleSecret);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception when initializing application {}", (Object)appId, (Object)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        String appId = context.getApplicationId().toString();
        try {
            this.logger.info("Stopping application {}", (Object)appId);
            if (this.isAuthenticationEnabled()) {
                this.secretManager.unregisterApp(appId);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception when stopping application {}", (Object)appId, (Object)e);
        }
    }

    public void initializeContainer(ContainerInitializationContext context) {
        ContainerId containerId = context.getContainerId();
        this.logger.info("Initializing container {}", (Object)containerId);
    }

    public void stopContainer(ContainerTerminationContext context) {
        ContainerId containerId = context.getContainerId();
        this.logger.info("Stopping container {}", (Object)containerId);
    }

    protected void serviceStop() {
        try {
            if (this.shuffleServer != null) {
                this.shuffleServer.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception when stopping service", (Throwable)e);
        }
    }

    public ByteBuffer getMetaData() {
        return ByteBuffer.allocate(0);
    }
}

