/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import org.apache.spark.network.util.ConfigProvider;

public class TransportConf {
    private final ConfigProvider conf;

    public TransportConf(ConfigProvider conf) {
        this.conf = conf;
    }

    public String ioMode() {
        return this.conf.get("spark.shuffle.io.mode", "NIO").toUpperCase();
    }

    public boolean preferDirectBufs() {
        return this.conf.getBoolean("spark.shuffle.io.preferDirectBufs", true);
    }

    public int connectionTimeoutMs() {
        return this.conf.getInt("spark.shuffle.io.connectionTimeout", 120) * 1000;
    }

    public int numConnectionsPerPeer() {
        return this.conf.getInt("spark.shuffle.io.numConnectionsPerPeer", 1);
    }

    public int backLog() {
        return this.conf.getInt("spark.shuffle.io.backLog", -1);
    }

    public int serverThreads() {
        return this.conf.getInt("spark.shuffle.io.serverThreads", 0);
    }

    public int clientThreads() {
        return this.conf.getInt("spark.shuffle.io.clientThreads", 0);
    }

    public int receiveBuf() {
        return this.conf.getInt("spark.shuffle.io.receiveBuffer", -1);
    }

    public int sendBuf() {
        return this.conf.getInt("spark.shuffle.io.sendBuffer", -1);
    }

    public int saslRTTimeoutMs() {
        return this.conf.getInt("spark.shuffle.sasl.timeout", 30) * 1000;
    }

    public int maxIORetries() {
        return this.conf.getInt("spark.shuffle.io.maxRetries", 3);
    }

    public int ioRetryWaitTimeMs() {
        return this.conf.getInt("spark.shuffle.io.retryWait", 5) * 1000;
    }

    public int memoryMapBytes() {
        return this.conf.getInt("spark.storage.memoryMapThreshold", 0x200000);
    }

    public boolean lazyFileDescriptor() {
        return this.conf.getBoolean("spark.shuffle.io.lazyFD", true);
    }
}

