/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaUtils.class);

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error("IOException should not have been thrown.", (Throwable)e);
        }
    }

    public static int nonNegativeHash(Object obj) {
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        return hash != Integer.MIN_VALUE ? Math.abs(hash) : 0;
    }

    public static ByteBuffer stringToBytes(String s) {
        return Unpooled.wrappedBuffer(s.getBytes(Charsets.UTF_8)).nioBuffer();
    }

    public static String bytesToString(ByteBuffer b) {
        return Unpooled.wrappedBuffer(b).toString(Charsets.UTF_8);
    }

    public static void deleteRecursively(File file) throws IOException {
        boolean deleted;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && !JavaUtils.isSymlink(file)) {
            IOException savedIOException = null;
            for (File child : JavaUtils.listFilesSafely(file)) {
                try {
                    JavaUtils.deleteRecursively(child);
                }
                catch (IOException e) {
                    savedIOException = e;
                }
            }
            if (savedIOException != null) {
                throw savedIOException;
            }
        }
        if (!(deleted = file.delete()) && file.exists()) {
            throw new IOException("Failed to delete: " + file.getAbsolutePath());
        }
    }

    private static File[] listFilesSafely(File file) throws IOException {
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Failed to list files for dir: " + file);
            }
            return files;
        }
        return new File[0];
    }

    private static boolean isSymlink(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        File fileInCanonicalDir = null;
        fileInCanonicalDir = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }
}

