/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class UploadBlock
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final String blockId;
    public final byte[] metadata;
    public final byte[] blockData;

    public UploadBlock(String appId, String execId, String blockId, byte[] metadata, byte[] blockData) {
        this.appId = appId;
        this.execId = execId;
        this.blockId = blockId;
        this.metadata = metadata;
        this.blockData = blockData;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.UPLOAD_BLOCK;
    }

    public int hashCode() {
        int objectsHashCode = Objects.hashCode((Object[])new Object[]{this.appId, this.execId, this.blockId});
        return (objectsHashCode * 41 + Arrays.hashCode(this.metadata)) * 41 + Arrays.hashCode(this.blockData);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("execId", (Object)this.execId).add("blockId", (Object)this.blockId).add("metadata size", this.metadata.length).add("block size", this.blockData.length).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof UploadBlock) {
            UploadBlock o = (UploadBlock)other;
            return Objects.equal((Object)this.appId, (Object)o.appId) && Objects.equal((Object)this.execId, (Object)o.execId) && Objects.equal((Object)this.blockId, (Object)o.blockId) && Arrays.equals(this.metadata, o.metadata) && Arrays.equals(this.blockData, o.blockData);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.appId) + Encoders.Strings.encodedLength(this.execId) + Encoders.Strings.encodedLength(this.blockId) + Encoders.ByteArrays.encodedLength(this.metadata) + Encoders.ByteArrays.encodedLength(this.blockData);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.appId);
        Encoders.Strings.encode(buf, this.execId);
        Encoders.Strings.encode(buf, this.blockId);
        Encoders.ByteArrays.encode(buf, this.metadata);
        Encoders.ByteArrays.encode(buf, this.blockData);
    }

    public static UploadBlock decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode(buf);
        String execId = Encoders.Strings.decode(buf);
        String blockId = Encoders.Strings.decode(buf);
        byte[] metadata = Encoders.ByteArrays.decode(buf);
        byte[] blockData = Encoders.ByteArrays.decode(buf);
        return new UploadBlock(appId, execId, blockId, metadata, blockData);
    }
}

