/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;

public class ExecutorShuffleInfo
implements Encodable {
    public final String[] localDirs;
    public final int subDirsPerLocalDir;
    public final String shuffleManager;

    public ExecutorShuffleInfo(String[] localDirs, int subDirsPerLocalDir, String shuffleManager) {
        this.localDirs = localDirs;
        this.subDirsPerLocalDir = subDirsPerLocalDir;
        this.shuffleManager = shuffleManager;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subDirsPerLocalDir, this.shuffleManager}) * 41 + Arrays.hashCode(this.localDirs);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("localDirs", (Object)Arrays.toString(this.localDirs)).add("subDirsPerLocalDir", this.subDirsPerLocalDir).add("shuffleManager", (Object)this.shuffleManager).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ExecutorShuffleInfo) {
            ExecutorShuffleInfo o = (ExecutorShuffleInfo)other;
            return Arrays.equals(this.localDirs, o.localDirs) && Objects.equal((Object)this.subDirsPerLocalDir, (Object)o.subDirsPerLocalDir) && Objects.equal((Object)this.shuffleManager, (Object)o.shuffleManager);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.StringArrays.encodedLength(this.localDirs) + 4 + Encoders.Strings.encodedLength(this.shuffleManager);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.StringArrays.encode(buf, this.localDirs);
        buf.writeInt(this.subDirsPerLocalDir);
        Encoders.Strings.encode(buf, this.shuffleManager);
    }

    public static ExecutorShuffleInfo decode(ByteBuf buf) {
        String[] localDirs = Encoders.StringArrays.decode(buf);
        int subDirsPerLocalDir = buf.readInt();
        String shuffleManager = Encoders.Strings.decode(buf);
        return new ExecutorShuffleInfo(localDirs, subDirsPerLocalDir, shuffleManager);
    }
}

